//code of the SHA1 function
function sha1(msg) {
      function rotate_left(n, s) {
            var t4 = (n << s) | (n >>> (32 - s));
            return t4;
      }
      ;
      function lsb_hex(val) {
            var str = '';
            var i;
            var vh;
            var vl;
            for (i = 0; i <= 6; i += 2) {
                  vh = (val >>> (i * 4 + 4)) & 0x0f;
                  vl = (val >>> (i * 4)) & 0x0f;
                  str += vh.toString(16) + vl.toString(16);
            }
            return str;
      }
      ;
      function cvt_hex(val) {
            var str = '';
            var i;
            var v;
            for (i = 7; i >= 0; i--) {
                  v = (val >>> (i * 4)) & 0x0f;
                  str += v.toString(16);
            }
            return str;
      }
      ;
      function Utf8Encode(string) {
            string = string.replace(/\r\n/g, '\n');
            var utftext = '';
            for (var n = 0; n < string.length; n++) {
                  var c = string.charCodeAt(n);
                  if (c < 128) {
                        utftext += String.fromCharCode(c);
                  } else if ((c > 127) && (c < 2048)) {
                        utftext += String.fromCharCode((c >> 6) | 192);
                        utftext += String.fromCharCode((c & 63) | 128);
                  } else {
                        utftext += String.fromCharCode((c >> 12) | 224);
                        utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                        utftext += String.fromCharCode((c & 63) | 128);
                  }
            }
            return utftext;
      }
      ;
      var blockstart;
      var i, j;
      var W = new Array(80);
      var H0 = 0x67452301;
      var H1 = 0xEFCDAB89;
      var H2 = 0x98BADCFE;
      var H3 = 0x10325476;
      var H4 = 0xC3D2E1F0;
      var A, B, C, D, E;
      var temp;
      msg = Utf8Encode(msg);
      var msg_len = msg.length;
      var word_array = new Array();
      for (i = 0; i < msg_len - 3; i += 4) {
            j = msg.charCodeAt(i) << 24 | msg.charCodeAt(i + 1) << 16 | msg.charCodeAt(i + 2) << 8 | msg.charCodeAt(i + 3);
            word_array.push(j);
      }
      switch (msg_len % 4) {
            case 0:
                  i = 0x080000000;
                  break;
            case 1:
                  i = msg.charCodeAt(msg_len - 1) << 24 | 0x0800000;
                  break;
            case 2:
                  i = msg.charCodeAt(msg_len - 2) << 24 | msg.charCodeAt(msg_len - 1) << 16 | 0x08000;
                  break;
            case 3:
                  i = msg.charCodeAt(msg_len - 3) << 24 | msg.charCodeAt(msg_len - 2) << 16 | msg.charCodeAt(msg_len - 1) << 8 | 0x80;
                  break;
      }
      word_array.push(i);
      while ((word_array.length % 16) != 14)
            word_array.push(0);
      word_array.push(msg_len >>> 29);
      word_array.push((msg_len << 3) & 0x0ffffffff);
      for (blockstart = 0; blockstart < word_array.length; blockstart += 16) {
            for (i = 0; i < 16; i++)
                  W[i] = word_array[blockstart + i];
            for (i = 16; i <= 79; i++)
                  W[i] = rotate_left(W[i - 3] ^ W[i - 8] ^ W[i - 14] ^ W[i - 16], 1);
            A = H0;
            B = H1;
            C = H2;
            D = H3;
            E = H4;
            for (i = 0; i <= 19; i++) {
                  temp = (rotate_left(A, 5) + ((B & C) | (~B & D)) + E + W[i] + 0x5A827999) & 0x0ffffffff;
                  E = D;
                  D = C;
                  C = rotate_left(B, 30);
                  B = A;
                  A = temp;
            }
            for (i = 20; i <= 39; i++) {
                  temp = (rotate_left(A, 5) + (B ^ C ^ D) + E + W[i] + 0x6ED9EBA1) & 0x0ffffffff;
                  E = D;
                  D = C;
                  C = rotate_left(B, 30);
                  B = A;
                  A = temp;
            }
            for (i = 40; i <= 59; i++) {
                  temp = (rotate_left(A, 5) + ((B & C) | (B & D) | (C & D)) + E + W[i] + 0x8F1BBCDC) & 0x0ffffffff;
                  E = D;
                  D = C;
                  C = rotate_left(B, 30);
                  B = A;
                  A = temp;
            }
            for (i = 60; i <= 79; i++) {
                  temp = (rotate_left(A, 5) + (B ^ C ^ D) + E + W[i] + 0xCA62C1D6) & 0x0ffffffff;
                  E = D;
                  D = C;
                  C = rotate_left(B, 30);
                  B = A;
                  A = temp;
            }
            H0 = (H0 + A) & 0x0ffffffff;
            H1 = (H1 + B) & 0x0ffffffff;
            H2 = (H2 + C) & 0x0ffffffff;
            H3 = (H3 + D) & 0x0ffffffff;
            H4 = (H4 + E) & 0x0ffffffff;
      }
      var temp = cvt_hex(H0) + cvt_hex(H1) + cvt_hex(H2) + cvt_hex(H3) + cvt_hex(H4);
      return temp.toLowerCase();
}
var contains = function (needle) {
      // Per spec, the way to identify NaN is that it is not equal to itself
      var findNaN = needle !== needle;
      var indexOf;
      if (!findNaN && typeof Array.prototype.indexOf === 'function') {
            indexOf = Array.prototype.indexOf;
      } else {
            indexOf = function (needle) {
                  var i = -1, index = -1;
                  for (i = 0; i < this.length; i++) {
                        var item = this[i];
                        if ((findNaN && item !== item) || item === needle) {
                              index = i;
                              break;
                        }
                  }
                  return index;
            };
      }
      return indexOf.call(this, needle) > -1;
};

setTimeout(function () {
      //Show last single listing info window with ctrl+alt+e
      document.addEventListener("keydown", function (zEvent) {
            if (zEvent.ctrlKey && zEvent.altKey && (zEvent.key === "e" || zEvent.key === "E" || zEvent.key === "е")) {  // case sensitive
                  chrome.storage.local.get(['pinnedListing'], function (result) {
                        if (result.pinnedListing !== null) {
                              plp_info_window = document.querySelectorAll('[class*="single_listing_info_window"]');
                              if (plp_info_window.length !== 0) {
                                    plp_info_window[0].remove();
                              } else {
                                    var node = document.createElement("div");
                                    node.innerHTML = result.pinnedListing + '<style>.remove_from_pinned_window {display:none}</style>';
                                    document.body.appendChild(node);
                              }
                        } else {
                              console.log('Nothing Pinned! ');
                        }
                  });
            }
            if (zEvent.ctrlKey && zEvent.altKey && (zEvent.key === "r" || zEvent.key === "R" || zEvent.key === "Р" || zEvent.key === "р")) {  // case sensitive
                  if (document.getElementById('plp_ext_near_by_search') !== null) {
                        document.getElementById('plp_ext_near_by_search').remove();
                  } else {
                        var s = document.createElement('script');
                        s.src = chrome.runtime.getURL('includes/near_by_search.js');
                        document.head.appendChild(s);
                  }
            }
      });
}, 500);

//Add the script only on G
n = window.location.host.startsWith("www.google");
n2 = window.location.host.startsWith("google");
//n3 = window.location.host.startsWith("www.duckduckgo");
//n4 = window.location.host.startsWith("duckduckgo");
n7 = window.location.host.startsWith("pleper");
n8 = window.location.host.startsWith("api.pleper.com");


if (n || n2) { //|| n3 || n4

      window.apple_maps_svg = '<?xml version="1.0" encoding="UTF-8" standalone="no"?><svg width="24px" height="24px" viewBox="0 0 256 315" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="xMidYMid"><g><path d="M213.803394,167.030943 C214.2452,214.609646 255.542482,230.442639 256,230.644727 C255.650812,231.761357 249.401383,253.208293 234.24263,275.361446 C221.138555,294.513969 207.538253,313.596333 186.113759,313.991545 C165.062051,314.379442 158.292752,301.507828 134.22469,301.507828 C110.163898,301.507828 102.642899,313.596301 82.7151126,314.379442 C62.0350407,315.16201 46.2873831,293.668525 33.0744079,274.586162 C6.07529317,235.552544 -14.5576169,164.286328 13.147166,116.18047 C26.9103111,92.2909053 51.5060917,77.1630356 78.2026125,76.7751096 C98.5099145,76.3877456 117.677594,90.4371851 130.091705,90.4371851 C142.497945,90.4371851 165.790755,73.5415029 190.277627,76.0228474 C200.528668,76.4495055 229.303509,80.1636878 247.780625,107.209389 C246.291825,108.132333 213.44635,127.253405 213.803394,167.030988 M174.239142,50.1987033 C185.218331,36.9088319 192.607958,18.4081019 190.591988,0 C174.766312,0.636050225 155.629514,10.5457909 144.278109,23.8283506 C134.10507,35.5906758 125.195775,54.4170275 127.599657,72.4607932 C145.239231,73.8255433 163.259413,63.4970262 174.239142,50.1987249" fill="#000000"></path></g></svg>'
      window.google_search_svg = '<svg viewBox=\"0 0 24 24\" style=\"fill:transparent\"><path fill=\"#4285F4\" d=\"M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z\"></path><path fill=\"#34A853\" d=\"M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z\"></path><path fill=\"#FBBC05\" d=\"M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z\"></path><path fill=\"#EA4335\" d=\"M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z\"></path><path fill=\"none\" d=\"M1 1h22v22H1z\"></path></svg>';
      window.google_guaranteed_svg = '<svg enable-background="new 0 0 2500 2500" viewBox="0 0 2500 2500" xmlns="http://www.w3.org/2000/svg" width="24px" height="24px"><circle cx="1250" cy="1250" fill="#53ba6f" r="1250"/><path d="m2493.8 1133.8-618.8-618.8-1150 1148.7 803.8 803.8c556.2-127.5 971.2-623.7 971.2-1217.5 0-38.7-2.5-77.5-6.2-116.2z" fill="#23893c"/><path d="m1875 515-883.7 883.8-353.8-353.8-265 265 618.8 618.7 1148.7-1148.7z" fill="#fff"/></svg>';
      var google_maps_svg = '<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" style=\"fill:transparent\"><path fill=\"#EA4335\" d=\"M9.84,6.93L6.4,4.04c-1.07,1.26-1.7,2.9-1.7,4.68c0,1.38,0.27,2.48,0.73,3.47l4.37-5.2  C9.8,6.97,9.81,6.95,9.84,6.93z\"></path><path fill=\"#1A73E8\" d=\"M11.97,1.44c-2.24,0-4.24,1.01-5.58,2.6l3.45,2.89c0.01-0.01,0.02-0.02,0.03-0.03l4.29-5.12  C13.47,1.56,12.73,1.44,11.97,1.44z\"></path><path fill=\"#4285F4\" d=\"M14.12,10.48l4.31-5.13c-0.88-1.69-2.41-2.99-4.26-3.57L9.83,6.93l0,0c0.51-0.61,1.28-1,2.14-1  c1.54,0,2.78,1.25,2.78,2.78C14.75,9.39,14.52,10,14.12,10.48z\"></path><path fill=\"#FBBC04\" d=\"M5.42,12.2c0.76,1.67,2.02,3.01,3.32,4.69l5.36-6.38l0,0c-0.51,0.6-1.28,0.99-2.12,0.99  c-1.54,0-2.78-1.25-2.78-2.78c0-0.65,0.23-1.26,0.61-1.74L5.42,12.2z\"></path><path fill=\"#34A853\" d=\"M19.25,8.72c0-1.22-0.3-2.36-0.83-3.37l-4.29,5.12c-0.01,0.01-0.01,0.02-0.03,0.03l-5.36,6.39  c0.42,0.54,0.85,1.13,1.26,1.77c1.48,2.28,1.04,3.65,1.97,3.65c0.96,0,0.53-1.37,2.01-3.65C16.42,14.87,19.25,13.14,19.25,8.72z\"></path></svg>';
      window.bing_logo_svg = '<?xml version="1.0" encoding="UTF-8" standalone="no"?><svg width="24px" height="24px" viewBox="0 0 256 320" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="xMidYMid"><g><path d="M95.055,82.908 L127.636,153.555 L175.78,175.332 L2.125,266.695 L73.279,203.267 L73.279,22.449 L0,0 L0,268.932 L72.83,319.986 L256,210.88 L256,132.227 L95.055,82.908" fill="#F4BD27"></path></g></svg>';
      window.yelp_logo_svg = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 120 120"><path d="M58.2 17.4c-.3-1.1-1.2-1.9-2.4-2.3-3.8-1-18.6 3.2-21.3 6.1-.9.9-1.2 2.1-.9 3.1.4.9 18.7 30.1 18.7 30.1 2.7 4.4 4.9 3.8 5.6 3.5.7-.2 2.9-.9 2.7-6.1-.4-6.1-2.2-33.1-2.4-34.4zm-7.9 54.8c1.5-.4 2.5-1.8 2.6-3.5.1-1.8-.8-3.4-2.3-4L46.4 63c-14.3-6-14.9-6.2-15.6-6.2-1.1-.1-2.1.5-2.8 1.6-1.4 2.3-2 9.7-1.5 14.6.2 1.6.5 3 .9 3.8.6 1.1 1.5 1.8 2.6 1.8.7 0 1.1-.1 14.4-4.4l5.9-2zm7.5 5.5c-1.6-.7-3.4-.3-4.4 1l-2.9 3.5c-10 12-10.4 12.5-10.7 13.2-.2.4-.2.9-.2 1.3 0 .6.3 1.3.8 1.8 2.3 2.8 13.4 7 17 6.4 1.2-.2 2.1-.9 2.5-2 .2-.7.3-1.2.3-15.3v-6.4c.2-1.5-.8-2.9-2.4-3.5zm34.8 2.8c-.6-.4-1-.6-14.3-5 0 0-5.8-2-5.9-2-1.4-.6-3-.1-4.1 1.3-1.1 1.4-1.3 3.2-.4 4.6l2.3 3.9c7.9 13 8.5 13.9 9 14.4.9.7 2 .8 3.2.3 3.4-1.4 10.7-10.8 11.2-14.5.2-1.2-.1-2.3-1-3zM71.2 65.7c2.1-.4 19.3-4.5 20.7-5.5.9-.6 1.4-1.7 1.3-3v-.1c-.8-3.8-6.9-13.6-10.1-15.2-1.1-.5-2.3-.5-3.2.1-.6.4-1 1-9.1 12.2l-3.7 5.1c-1 1.2-1 2.9 0 4.4 1 1.6 2 2.4 4.1 2z"/></svg>';
      window.duckduck_logo_svg = '<svg height="24" viewBox="0 0 32 32" width="24" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><clipPath id="a"><path d="m178.684 78.824c0 28.316-23.035 51.354-51.354 51.354-28.313 0-51.348-23.04-51.348-51.354s23.036-51.35 51.348-51.35c28.318 0 51.354 23.036 51.354 51.35z"/></clipPath><linearGradient id="b"><stop offset=".006" stop-color="#6176b9"/><stop offset=".691" stop-color="#394a9f"/></linearGradient><linearGradient id="c" gradientUnits="userSpaceOnUse" x1="105.318" x2="113.887" xlink:href="#b" y1="60.979" y2="60.979"/><linearGradient id="d" gradientUnits="userSpaceOnUse" x1="132.273" x2="140.078" xlink:href="#b" y1="58.371" y2="58.371"/><g transform="matrix(.266667 0 0 .266667 -17.954934 -5.057333)"><circle cx="127.332" cy="78.966" fill="#de5833" r="51.15"/><g clip-path="url(#a)"><path d="m148.293 155.158c-1.8-8.285-12.262-27.04-16.23-34.97s-7.938-19.1-6.13-26.322c.328-1.312-3.436-11.308-2.354-12.015 8.416-5.5 10.632.6 14.002-1.862 1.734-1.273 4.1 1.047 4.7-1.06 2.158-7.567-3.006-20.76-8.77-26.526-1.885-1.88-4.77-3.06-8.03-3.687-1.254-1.713-3.275-3.36-6.138-4.88-3.188-1.697-10.12-3.938-13.717-4.535-2.492-.4-3.055.287-4.12.46.992.088 5.7 2.414 6.615 2.55-.916.62-3.607-.028-5.324.742-.865.392-1.512 1.877-1.506 2.58 4.9-.496 12.574-.016 17.1 2-3.602.4-9.08.867-11.436 2.105-6.848 3.608-9.873 12.035-8.07 22.133 1.804 10.075 9.738 46.85 12.262 59.13 2.525 12.264-5.408 20.2-10.455 22.354l5.408.363-1.8 3.967c6.484.72 13.695-1.44 13.695-1.44-1.438 3.965-11.176 5.412-11.176 5.412s4.7 1.438 12.258-1.447l12.263-4.688 3.604 9.373 6.854-6.847 2.885 7.2c.014-.001 5.424-1.808 3.62-10.103z" fill="#d5d7d8"/><path d="m150.47 153.477c-1.795-8.3-12.256-27.043-16.228-34.98s-7.935-19.112-6.13-26.32c.335-1.3.34-6.668 1.43-7.38 8.4-5.494 7.812-.184 11.187-2.645 1.74-1.27 3.133-2.806 3.738-4.912 2.164-7.572-3.006-20.76-8.773-26.53-1.88-1.88-4.768-3.062-8.023-3.686-1.252-1.718-3.27-3.36-6.13-4.882-5.4-2.862-12.074-4.006-18.266-2.883 1 .1 3.256 2.138 4.168 2.273-1.38.936-5.053.815-5.03 2.896 4.916-.492 10.303.285 14.834 2.297-3.602.4-6.955 1.3-9.3 2.543-6.854 3.603-8.656 10.812-6.854 20.914 1.807 10.097 9.742 46.873 12.256 59.126 2.527 12.26-5.402 20.188-10.45 22.354l5.408.36-1.8 3.973c6.484.72 13.695-1.44 13.695-1.44-1.438 3.974-11.176 5.406-11.176 5.406s4.686 1.44 12.258-1.445l12.27-4.688 3.604 9.373 6.852-6.85 2.9 7.215c-.016.007 5.388-1.797 3.58-10.088z" fill="#fff"/><path d="m109.02 70.69c0-2.093 1.693-3.787 3.79-3.787 2.1 0 3.785 1.694 3.785 3.787s-1.695 3.786-3.785 3.786c-2.096.001-3.79-1.692-3.79-3.786z" fill="#2d4f8e"/><path d="m113.507 69.43a.98.98 0 0 1 .98-.983c.543 0 .984.438.984.983s-.44.984-.984.984c-.538.001-.98-.44-.98-.984z" fill="#fff"/><path d="m134.867 68.445c0-1.793 1.46-3.25 3.252-3.25 1.8 0 3.256 1.457 3.256 3.25 0 1.8-1.455 3.258-3.256 3.258a3.26 3.26 0 0 1 -3.252-3.258z" fill="#2d4f8e"/><path d="m138.725 67.363c0-.463.38-.843.838-.843a.84.84 0 0 1 .846.843c0 .47-.367.842-.846.842a.84.84 0 0 1 -.838-.842z" fill="#fff"/><path d="m113.886 59.718s-2.854-1.3-5.63.453-2.668 3.523-2.668 3.523-1.473-3.283 2.453-4.892 5.844.916 5.844.916z" fill="url(#c)"/><path d="m140.078 59.458s-2.05-1.172-3.643-1.152c-3.27.043-4.162 1.488-4.162 1.488s.55-3.445 4.732-2.754c2.268.377 3.073 2.418 3.073 2.418z" fill="url(#d)"/></g><path d="m124.4 85.295c.38-2.3 6.3-6.625 10.5-6.887 4.2-.265 5.5-.205 9-1.043s12.535-3.088 15.033-4.242c2.504-1.156 13.104.572 5.63 4.738-3.232 1.8-11.943 5.13-18.172 6.987-6.22 1.86-10-1.776-12.06 1.28-1.646 2.432-.334 5.762 7.1 6.453 10.037.93 19.66-4.52 20.72-1.625s-8.625 6.508-14.525 6.623c-5.893.1-17.77-3.896-19.555-5.137s-4.165-4.13-3.67-7.148z" fill="#fdd20a"/><path d="m128.943 115.592s-14.102-7.52-14.332-4.47c-.238 3.056 0 15.5 1.643 16.45s13.396-6.108 13.396-6.108zm5.403-.474s9.635-7.285 11.754-6.815c2.1.48 2.582 15.5.7 16.23-1.88.7-12.908-3.813-12.908-3.813z" fill="#65bc46"/><path d="m125.53 116.4c0 4.932-.7 7.05 1.4 7.52s6.104 0 7.518-.938.232-7.28-.232-8.465c-.477-1.174-8.696-.232-8.696 1.884z" fill="#43a244"/><path d="m126.426 115.292c0 4.933-.707 7.05 1.4 7.52 2.106.48 6.104 0 7.52-.938 1.4-.94.23-7.28-.236-8.466-.473-1.173-8.692-.227-8.692 1.885z" fill="#65bc46"/><circle cx="127.331" cy="78.965" fill="none" r="57.5" stroke="#de5833" stroke-width="5"/></g></svg>';
      window.facebook_logo = '<?xml version="1.0" encoding="utf-8"?><svg width="24" height="24" version="1.1" id="facebook" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"	 viewBox="0 0 64 64" style="enable-background:new 0 0 64 64;" xml:space="preserve"><style type="text/css">	.st0{fill:#3D5A98;}	.st1{fill:#FFFFFF;}</style><path id="Blue_1_" class="st0" d="M60.5,64c2,0,3.5-1.6,3.5-3.5V3.5c0-2-1.6-3.5-3.5-3.5H3.5C1.6,0,0,1.6,0,3.5v56.9	c0,2,1.6,3.5,3.5,3.5H60.5z"/><path id="f" class="st1" d="M44.2,64V39.2h8.3l1.2-9.7h-9.6v-6.2c0-2.8,0.8-4.7,4.8-4.7l5.1,0V10c-0.9-0.1-3.9-0.4-7.5-0.4	c-7.4,0-12.4,4.5-12.4,12.8v7.1h-8.3v9.7h8.3V64H44.2z"/></svg>';
      window.wikipedia_logo = '<?xml version="1.0" encoding="UTF-8"?><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="28px" height="28px" viewBox="0 0 26 26" version="1.1"><g id="surface1"><path style=" stroke:none;fill-rule:evenodd;fill:rgb(0%,0%,0%);fill-opacity:1;" d="M 24.546875 5.933594 C 24.546875 6.015625 24.519531 6.089844 24.46875 6.160156 C 24.417969 6.226562 24.363281 6.261719 24.300781 6.261719 C 23.792969 6.3125 23.378906 6.472656 23.058594 6.75 C 22.734375 7.027344 22.402344 7.558594 22.058594 8.339844 L 16.820312 20.148438 C 16.785156 20.257812 16.6875 20.3125 16.53125 20.3125 C 16.40625 20.3125 16.3125 20.257812 16.242188 20.148438 L 13.300781 14 L 9.921875 20.148438 C 9.855469 20.257812 9.757812 20.3125 9.632812 20.3125 C 9.484375 20.3125 9.382812 20.257812 9.335938 20.148438 L 4.1875 8.339844 C 3.867188 7.605469 3.527344 7.09375 3.167969 6.800781 C 2.8125 6.511719 2.316406 6.332031 1.679688 6.261719 C 1.625 6.261719 1.570312 6.234375 1.527344 6.175781 C 1.476562 6.117188 1.453125 6.050781 1.453125 5.976562 C 1.453125 5.78125 1.507812 5.6875 1.617188 5.6875 C 2.074219 5.6875 2.554688 5.707031 3.058594 5.75 C 3.523438 5.792969 3.960938 5.8125 4.371094 5.8125 C 4.789062 5.8125 5.285156 5.792969 5.851562 5.75 C 6.445312 5.707031 6.976562 5.6875 7.433594 5.6875 C 7.542969 5.6875 7.597656 5.78125 7.597656 5.976562 C 7.597656 6.167969 7.5625 6.261719 7.496094 6.261719 C 7.039062 6.296875 6.675781 6.414062 6.414062 6.613281 C 6.148438 6.8125 6.015625 7.070312 6.015625 7.394531 C 6.015625 7.558594 6.070312 7.761719 6.179688 8.007812 L 10.4375 17.617188 L 12.851562 13.058594 L 10.601562 8.339844 C 10.195312 7.496094 9.863281 6.953125 9.605469 6.710938 C 9.34375 6.46875 8.949219 6.316406 8.421875 6.261719 C 8.371094 6.261719 8.328125 6.234375 8.285156 6.175781 C 8.238281 6.117188 8.214844 6.050781 8.214844 5.976562 C 8.214844 5.78125 8.261719 5.6875 8.359375 5.6875 C 8.820312 5.6875 9.238281 5.707031 9.625 5.75 C 9.992188 5.792969 10.386719 5.8125 10.804688 5.8125 C 11.214844 5.8125 11.652344 5.792969 12.109375 5.75 C 12.582031 5.707031 13.046875 5.6875 13.507812 5.6875 C 13.617188 5.6875 13.671875 5.78125 13.671875 5.976562 C 13.671875 6.167969 13.640625 6.261719 13.570312 6.261719 C 12.652344 6.324219 12.195312 6.585938 12.195312 7.042969 C 12.195312 7.25 12.300781 7.570312 12.511719 8 L 14 11.023438 L 15.480469 8.257812 C 15.6875 7.867188 15.789062 7.539062 15.789062 7.269531 C 15.789062 6.640625 15.332031 6.304688 14.414062 6.261719 C 14.332031 6.261719 14.289062 6.167969 14.289062 5.976562 C 14.289062 5.90625 14.308594 5.84375 14.351562 5.78125 C 14.394531 5.71875 14.433594 5.6875 14.476562 5.6875 C 14.804688 5.6875 15.207031 5.707031 15.6875 5.75 C 16.144531 5.792969 16.523438 5.8125 16.820312 5.8125 C 17.03125 5.8125 17.34375 5.792969 17.753906 5.757812 C 18.273438 5.710938 18.710938 5.6875 19.058594 5.6875 C 19.140625 5.6875 19.179688 5.769531 19.179688 5.933594 C 19.179688 6.152344 19.105469 6.261719 18.957031 6.261719 C 18.421875 6.316406 17.992188 6.464844 17.664062 6.707031 C 17.339844 6.945312 16.933594 7.488281 16.449219 8.339844 L 14.476562 11.988281 L 17.148438 17.433594 L 21.09375 8.257812 C 21.230469 7.921875 21.300781 7.613281 21.300781 7.332031 C 21.300781 6.660156 20.839844 6.304688 19.921875 6.261719 C 19.839844 6.261719 19.796875 6.167969 19.796875 5.976562 C 19.796875 5.78125 19.859375 5.6875 19.984375 5.6875 C 20.320312 5.6875 20.714844 5.707031 21.175781 5.75 C 21.601562 5.792969 21.957031 5.8125 22.246094 5.8125 C 22.546875 5.8125 22.894531 5.792969 23.292969 5.75 C 23.703125 5.707031 24.074219 5.6875 24.402344 5.6875 C 24.5 5.6875 24.546875 5.769531 24.546875 5.933594 Z M 24.546875 5.933594 "/></g></svg>';
      window.foursquare_logo = '<?xml version="1.0" encoding="UTF-8"?> <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="26" height="26" viewBox="0 0 26 26" version="1.1"> <g id="surface1"> <path style=" stroke:none;fill-rule:nonzero;fill:rgb(98.039216%,27.843137%,47.058824%);fill-opacity:1;" d="M 19.203125 3.753906 L 18.582031 6.761719 C 18.511719 7.082031 18.207031 7.371094 17.835938 7.371094 L 12.425781 7.371094 C 11.816406 7.375 11.324219 7.867188 11.320312 8.472656 L 11.320312 9.132812 C 11.324219 9.742188 11.816406 10.234375 12.425781 10.234375 L 17 10.234375 C 17.425781 10.234375 17.78125 10.644531 17.691406 11.089844 L 17.070312 14.152344 C 17.035156 14.417969 16.75 14.761719 16.320312 14.761719 L 12.585938 14.761719 C 11.804688 14.777344 11.644531 14.796875 11.179688 15.371094 L 6.625 21.050781 C 6.589844 21.101562 6.554688 21.085938 6.554688 21.03125 L 6.554688 3.617188 C 6.554688 3.203125 6.890625 2.871094 7.300781 2.867188 L 18.523438 2.867188 C 18.917969 2.867188 19.308594 3.257812 19.199219 3.761719 M 20.023438 0 L 6.160156 0 C 4.257812 0 3.6875 1.441406 3.6875 2.347656 L 3.6875 24.378906 C 3.6875 25.464844 4.242188 25.78125 4.542969 25.90625 C 4.84375 26.03125 5.644531 26.121094 6.214844 25.550781 L 12.90625 17.757812 C 13.011719 17.632812 13.066406 17.632812 13.136719 17.632812 L 17.300781 17.632812 C 19.082031 17.632812 19.417969 16.40625 19.613281 15.660156 C 19.773438 15.035156 21.609375 6.136719 22.179688 3.328125 C 22.605469 1.15625 22.050781 0 20.023438 0 "/> </g> </svg> ';
      window.semrush_logo = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="height: 20px; " viewBox="0 -3 38 24"><path d="M30.19 10.368c0 .648-.33.753-1.15.753-.872 0-1.031-.145-1.124-.806-.172-1.68-1.309-3.108-3.213-3.267-.608-.052-.754-.277-.754-1.031 0-.7.106-1.031.648-1.031 3.306.013 5.594 2.67 5.594 5.382zm4.814 0C35.004 5.329 31.593 0 23.711 0H8.054c-.318 0-.516.159-.516.45 0 .158.119.304.225.383.568.45 1.415.952 2.525 1.508 1.085.542 1.931.899 2.777 1.243.357.145.49.304.49.502 0 .278-.199.45-.582.45H.543c-.371 0-.543.238-.543.476 0 .198.066.37.238.542 1.005 1.058 2.618 2.328 4.96 3.796a71.557 71.557 0 006.611 3.636c.344.159.45.344.45.542-.013.225-.185.41-.582.41h-5.7c-.317 0-.502.172-.502.437 0 .145.119.33.278.476 1.295 1.177 3.372 2.46 6.136 3.636C15.579 20.061 19.32 21 23.526 21c7.974 0 11.478-5.964 11.478-10.632zm-10.407 7.445c-4.073 0-7.485-3.32-7.485-7.458 0-4.074 3.399-7.353 7.485-7.353 4.179 0 7.458 3.266 7.458 7.353-.013 4.139-3.28 7.458-7.458 7.458z" fill="#FF642D"></path></svg>';
      window.brightlocal_logo = "<img width='28px' src='data:image/webp;base64,UklGRtoBAABXRUJQVlA4TM4BAAAvH8AHEFehOJKkBHf5EQ75F8nwPUHSYBtJkpPX+hEWaZB/GkSCBX+SQQCAZWZbtda/xW0oaNvI8Q3ah+qZPJ2l+Po3w3mE/l9YuL/516N7Pl+IMSWjC4sLmwMLXrMLC/oG/I94jQ4sLqwun9bzebbY7we0SV3op1e6YhJlA1Y3w2XGZ2ZcRWxSKIRNwrw7n7myKbFJbTPqpuWpwWFkW2nFxeLG++7yov13CLEOIvo/AUJoJbGxVFoIobCrEho7a7WXkiGTZKmZkZ/n6z8j4ZvCERHVGQD56JmZh2vkBeOGqjxOipoKRBPPjtGMbShFsKBq4oVjFCopA0yWGqA48OJzwLoSyB2Ri4HR62/P0Wv/XkoZEirjtGlk1DJzGwEYmZlfXk4xcrJATsmXmfkCAG/vFjLIKfXij3f2ngtSSmBcneauQqD9AWbwXp51JZDURJXB1+P2cu2YmdvIQ04pgFgC+AfmLwjK2qUIR8tGE4KtXRrCoiHCvK1dGuoW9H8stTVlgX5u+GO5qSj3hpkxwlpZUgFgDE0GG5ZUAlPgIrFpQaU8e1dsnVN1YeY7ts/oxPzEnumxfWOlXIHfByulWrNe6b20UPsoIYRWciuptBA='>";
      window.serpsta_logo = "<img width='28px' src='data:image/png;base64,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'>";
      window.namecheap_logo = '<?xml version="1.0" encoding="UTF-8"?><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  width="26px" viewBox="0 -10 62 45" version="1.1"><g id="surface1"><path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,31.764706%,0%);fill-opacity:1;" d="M 56.683594 0.160156 C 54.558594 0.160156 52.597656 1.316406 51.566406 3.175781 L 51.445312 3.421875 L 46.882812 12.476562 L 41.078125 23.921875 L 44.882812 31.421875 L 45.089844 31.832031 C 45.675781 32.871094 46.5625 33.707031 47.628906 34.238281 C 48.695312 33.707031 49.578125 32.867188 50.164062 31.832031 L 50.375 31.421875 L 61.765625 8.925781 L 62.042969 8.382812 C 62.828125 6.574219 62.65625 4.492188 61.578125 2.839844 C 60.5 1.191406 58.664062 0.195312 56.691406 0.191406 Z M 56.683594 0.160156 "/><path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,31.764706%,0%);fill-opacity:1;" d="M 21.46875 11.054688 L 17.675781 3.609375 L 17.464844 3.199219 C 16.882812 2.160156 16.003906 1.324219 14.9375 0.800781 C 13.871094 1.324219 12.988281 2.15625 12.40625 3.191406 L 12.191406 3.609375 L 0.78125 26.082031 L 0.507812 26.617188 C -0.773438 29.484375 0.433594 32.847656 3.238281 34.246094 C 6.046875 35.644531 9.457031 34.578125 10.96875 31.832031 L 11.097656 31.59375 L 15.6875 22.539062 L 21.484375 11.097656 Z M 21.46875 11.054688 "/><path style=" stroke:none;fill-rule:nonzero;fill:url(#linear0);" d="M 56.667969 0.160156 C 54.542969 0.160156 52.585938 1.316406 51.558594 3.175781 L 51.429688 3.421875 L 46.839844 12.476562 L 41.027344 23.921875 L 44.835938 31.421875 L 45.046875 31.832031 C 45.628906 32.871094 46.515625 33.710938 47.582031 34.238281 C 48.652344 33.710938 49.535156 32.871094 50.121094 31.832031 L 50.335938 31.421875 L 61.765625 8.925781 L 62.035156 8.382812 C 62.824219 6.574219 62.648438 4.492188 61.570312 2.839844 C 60.492188 1.191406 58.65625 0.195312 56.683594 0.191406 Z M 56.667969 0.160156 "/><path style=" stroke:none;fill-rule:nonzero;fill:url(#linear1);" d="M 5.847656 34.847656 C 7.964844 34.855469 9.921875 33.714844 10.960938 31.867188 L 11.089844 31.621094 L 15.6875 22.566406 L 21.492188 11.121094 L 17.6875 3.585938 L 17.480469 3.175781 C 16.894531 2.136719 16.007812 1.300781 14.9375 0.769531 C 13.867188 1.300781 12.984375 2.136719 12.398438 3.175781 L 12.191406 3.585938 L 0.746094 26.082031 L 0.46875 26.625 C -0.316406 28.433594 -0.144531 30.515625 0.933594 32.167969 C 2.011719 33.816406 3.847656 34.8125 5.820312 34.816406 Z M 5.847656 34.847656 "/><path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,54.901961%,26.666667%);fill-opacity:1;" d="M 21.46875 11.054688 L 17.675781 3.609375 L 17.464844 3.199219 C 16.882812 2.160156 15.996094 1.320312 14.929688 0.792969 C 15.285156 0.617188 15.65625 0.480469 16.039062 0.375 C 16.523438 0.253906 17.023438 0.191406 17.527344 0.191406 L 25.472656 0.191406 C 27.585938 0.195312 29.53125 1.332031 30.578125 3.167969 L 30.785156 3.578125 L 41.0625 23.953125 L 44.851562 31.398438 L 45.058594 31.808594 C 45.652344 32.859375 46.546875 33.707031 47.628906 34.238281 C 46.824219 34.628906 45.941406 34.835938 45.046875 34.839844 L 37.054688 34.839844 C 34.941406 34.832031 33 33.695312 31.957031 31.859375 L 31.738281 31.453125 Z M 21.46875 11.054688 "/></g></svg>';
      window.yellow_star = '<?xml version="1.0" encoding="UTF-8"?><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="25px" height="25px" viewBox="0 0 28 27" version="1.1"><g id="surface1"><path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,80%,0%);fill-opacity:1;" d="M 22.648438 26.964844 L 13.996094 22.363281 L 5.34375 26.960938 L 6.996094 17.21875 L 0 10.316406 L 9.671875 8.898438 L 14 0.0351562 L 18.324219 8.898438 L 28 10.320312 L 20.996094 17.21875 Z M 22.648438 26.964844 "/><path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,90.196078%,50.196078%);fill-opacity:1;" d="M 18.355469 8.84375 C 13.972656 14.875 13.925781 14.9375 13.925781 14.9375 L 27.96875 10.289062 Z M 18.355469 8.84375 "/><path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,86.666667%,33.333333%);fill-opacity:1;" d="M 13.996094 14.808594 L 13.996094 22.382812 L 5.257812 26.917969 Z M 13.996094 14.808594 "/><path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,86.666667%,33.333333%);fill-opacity:1;" d="M 13.996094 14.808594 L 22.59375 26.6875 L 20.980469 17.066406 Z M 13.996094 14.808594 "/><path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,90.196078%,50.196078%);fill-opacity:1;" d="M 0.0546875 10.296875 L 14 14.808594 L 9.691406 8.855469 Z M 0.0546875 10.296875 "/><path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,86.666667%,33.333333%);fill-opacity:1;" d="M 13.996094 14.808594 L 13.996094 0.0546875 L 18.296875 8.851562 Z M 13.996094 14.808594 "/><path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,83.137255%,16.470588%);fill-opacity:1;" d="M 5.347656 26.796875 L 6.96875 17.09375 L 14 14.808594 Z M 5.347656 26.796875 "/></g></svg>';
      window.schema_logo = '<?xml version="1.0" encoding="UTF-8"?><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="25px" height="25px" viewBox="0 0 32 32" version="1.1"><defs><g><symbol overflow="visible" id="glyph0-0"><path style="stroke:none;" d="M 1.28125 4.4375 L 1.28125 -17.6875 L 13.828125 -17.6875 L 13.828125 4.4375 Z M 2.6875 3.03125 L 12.421875 3.03125 L 12.421875 -16.28125 L 2.6875 -16.28125 Z M 2.6875 3.03125 "/></symbol><symbol overflow="visible" id="glyph0-1"><path style="stroke:none;" d="M 12.40625 2.328125 L 12.40625 4.09375 L 11.609375 4.09375 C 9.578125 4.09375 8.21875 3.789062 7.53125 3.1875 C 6.84375 2.582031 6.5 1.378906 6.5 -0.421875 L 6.5 -3.359375 C 6.5 -4.585938 6.28125 -5.4375 5.84375 -5.90625 C 5.40625 -6.382812 4.613281 -6.625 3.46875 -6.625 L 2.703125 -6.625 L 2.703125 -8.375 L 3.46875 -8.375 C 4.613281 -8.375 5.40625 -8.609375 5.84375 -9.078125 C 6.28125 -9.546875 6.5 -10.390625 6.5 -11.609375 L 6.5 -14.5625 C 6.5 -16.363281 6.84375 -17.5625 7.53125 -18.15625 C 8.21875 -18.757812 9.578125 -19.0625 11.609375 -19.0625 L 12.40625 -19.0625 L 12.40625 -17.3125 L 11.546875 -17.3125 C 10.398438 -17.3125 9.648438 -17.132812 9.296875 -16.78125 C 8.953125 -16.425781 8.78125 -15.664062 8.78125 -14.5 L 8.78125 -11.46875 C 8.78125 -10.1875 8.59375 -9.253906 8.21875 -8.671875 C 7.851562 -8.097656 7.222656 -7.707031 6.328125 -7.5 C 7.234375 -7.28125 7.867188 -6.878906 8.234375 -6.296875 C 8.597656 -5.710938 8.78125 -4.785156 8.78125 -3.515625 L 8.78125 -0.484375 C 8.78125 0.691406 8.953125 1.453125 9.296875 1.796875 C 9.648438 2.148438 10.398438 2.328125 11.546875 2.328125 Z M 12.40625 2.328125 "/></symbol><symbol overflow="visible" id="glyph1-0"><path style="stroke:none;" d="M 1.25 4.4375 L 1.25 -17.6875 L 13.796875 -17.6875 L 13.796875 4.4375 Z M 2.65625 3.03125 L 12.40625 3.03125 L 12.40625 -16.28125 L 2.65625 -16.28125 Z M 2.65625 3.03125 "/></symbol><symbol overflow="visible" id="glyph1-1"><path style="stroke:none;" d="M 3.140625 2.328125 L 4 2.328125 C 5.132812 2.328125 5.875 2.148438 6.21875 1.796875 C 6.570312 1.453125 6.75 0.691406 6.75 -0.484375 L 6.75 -3.515625 C 6.75 -4.785156 6.929688 -5.710938 7.296875 -6.296875 C 7.671875 -6.878906 8.3125 -7.28125 9.21875 -7.5 C 8.3125 -7.707031 7.671875 -8.097656 7.296875 -8.671875 C 6.929688 -9.253906 6.75 -10.1875 6.75 -11.46875 L 6.75 -14.5 C 6.75 -15.664062 6.570312 -16.425781 6.21875 -16.78125 C 5.875 -17.132812 5.132812 -17.3125 4 -17.3125 L 3.140625 -17.3125 L 3.140625 -19.0625 L 3.90625 -19.0625 C 5.9375 -19.0625 7.289062 -18.757812 7.96875 -18.15625 C 8.65625 -17.5625 9 -16.363281 9 -14.5625 L 9 -11.609375 C 9 -10.398438 9.21875 -9.554688 9.65625 -9.078125 C 10.101562 -8.609375 10.90625 -8.375 12.0625 -8.375 L 12.828125 -8.375 L 12.828125 -6.625 L 12.0625 -6.625 C 10.90625 -6.625 10.101562 -6.382812 9.65625 -5.90625 C 9.21875 -5.4375 9 -4.585938 9 -3.359375 L 9 -0.421875 C 9 1.378906 8.65625 2.582031 7.96875 3.1875 C 7.289062 3.789062 5.9375 4.09375 3.90625 4.09375 L 3.140625 4.09375 Z M 3.140625 2.328125 "/></symbol></g></defs><g id="surface1"><g style="fill:rgb(0%,0%,0%);fill-opacity:1;">  <use xlink:href="#glyph0-1" x="-2.707031" y="23.490343"/></g><g style="fill:rgb(0%,0%,0%);fill-opacity:1;">  <use xlink:href="#glyph1-1" x="19.167969" y="23.490343"/></g><path style=" stroke:none;fill-rule:nonzero;fill:rgb(4.705882%,27.843137%,61.176471%);fill-opacity:1;" d="M 21.734375 18.769531 C 21.625 18.710938 21.511719 18.660156 21.398438 18.617188 L 21.476562 18.609375 C 21.476562 18.609375 20.753906 18.289062 20.691406 15.964844 C 20.628906 13.640625 21.382812 13.242188 21.382812 13.242188 L 21.273438 13.246094 C 21.839844 12.957031 22.332031 12.496094 22.652344 11.886719 C 23.492188 10.304688 22.890625 8.339844 21.3125 7.5 C 19.726562 6.660156 17.765625 7.261719 16.925781 8.84375 C 16.578125 9.492188 16.480469 10.207031 16.589844 10.878906 L 16.554688 10.824219 C 16.554688 10.824219 16.742188 11.667969 14.765625 12.894531 C 12.785156 14.125 11.894531 13.511719 11.894531 13.511719 L 11.949219 13.597656 C 11.894531 13.5625 11.839844 13.523438 11.78125 13.492188 C 10.199219 12.652344 8.234375 13.253906 7.394531 14.835938 C 6.554688 16.417969 7.15625 18.382812 8.734375 19.222656 C 9.914062 19.847656 11.304688 19.675781 12.285156 18.890625 L 12.265625 18.929688 C 12.265625 18.929688 12.984375 18.339844 15.0625 19.453125 C 16.699219 20.332031 16.941406 21.195312 16.972656 21.519531 C 16.929688 22.71875 17.558594 23.898438 18.691406 24.5 C 20.273438 25.339844 22.238281 24.738281 23.078125 23.15625 C 23.917969 21.574219 23.316406 19.609375 21.734375 18.769531 Z M 18.078125 19.195312 C 17.816406 19.289062 17.066406 19.390625 15.488281 18.546875 C 13.78125 17.628906 13.527344 16.863281 13.492188 16.632812 C 13.515625 16.355469 13.5 16.078125 13.453125 15.804688 L 13.460938 15.820312 C 13.460938 15.820312 13.324219 15.074219 15.277344 13.863281 C 17.027344 12.777344 17.820312 12.992188 17.96875 13.050781 C 18.0625 13.113281 18.164062 13.175781 18.265625 13.230469 C 18.464844 13.335938 18.664062 13.417969 18.871094 13.476562 C 19.113281 13.707031 19.554688 14.355469 19.601562 16.066406 C 19.648438 17.789062 19.140625 18.453125 18.867188 18.6875 C 18.582031 18.816406 18.316406 18.988281 18.078125 19.195312 Z M 18.078125 19.195312 "/><path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,100%,100%);fill-opacity:1;" d="M 17.863281 8.53125 C 16.917969 9.566406 16.898438 11.082031 17.808594 11.941406 C 17.359375 11.511719 17.367188 10.609375 17.824219 9.746094 C 17.882812 9.667969 18.050781 9.488281 18.296875 9.570312 C 18.324219 9.578125 18.339844 9.582031 18.347656 9.578125 C 18.40625 9.589844 18.460938 9.597656 18.519531 9.597656 C 18.898438 9.578125 19.1875 9.261719 19.171875 8.886719 C 19.164062 8.71875 19.09375 8.566406 18.984375 8.453125 C 19.855469 7.882812 20.859375 7.816406 21.265625 8.191406 L 21.285156 8.191406 C 20.347656 7.335938 18.816406 7.488281 17.863281 8.53125 Z M 17.863281 8.53125 "/><path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,100%,100%);fill-opacity:1;" d="M 8.34375 18.074219 C 8.335938 18.066406 8.328125 18.058594 8.320312 18.050781 C 8.324219 18.054688 8.328125 18.0625 8.335938 18.066406 Z M 8.34375 18.074219 "/><path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,100%,100%);fill-opacity:1;" d="M 8.375 14.636719 C 7.429688 15.671875 7.410156 17.191406 8.320312 18.050781 C 7.871094 17.617188 7.878906 16.714844 8.335938 15.851562 C 8.394531 15.777344 8.5625 15.59375 8.808594 15.675781 C 8.835938 15.683594 8.851562 15.6875 8.859375 15.6875 C 8.917969 15.699219 8.972656 15.703125 9.03125 15.703125 C 9.410156 15.683594 9.699219 15.367188 9.683594 14.992188 C 9.675781 14.824219 9.605469 14.671875 9.496094 14.558594 C 10.367188 13.988281 11.371094 13.921875 11.777344 14.296875 L 11.792969 14.296875 C 10.859375 13.441406 9.328125 13.59375 8.375 14.636719 Z M 8.375 14.636719 "/><path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,100%,100%);fill-opacity:1;" d="M 18.390625 23.246094 C 18.378906 23.238281 18.371094 23.226562 18.363281 23.21875 C 18.371094 23.222656 18.375 23.230469 18.378906 23.238281 Z M 18.390625 23.246094 "/><path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,100%,100%);fill-opacity:1;" d="M 18.417969 19.808594 C 17.476562 20.839844 17.453125 22.359375 18.363281 23.21875 C 17.914062 22.785156 17.925781 21.886719 18.378906 21.023438 C 18.4375 20.945312 18.605469 20.761719 18.855469 20.847656 C 18.878906 20.855469 18.894531 20.855469 18.90625 20.855469 C 18.960938 20.867188 19.019531 20.875 19.078125 20.871094 C 19.453125 20.855469 19.742188 20.535156 19.726562 20.160156 C 19.71875 19.992188 19.648438 19.84375 19.539062 19.730469 C 20.414062 19.15625 21.414062 19.09375 21.824219 19.46875 L 21.839844 19.46875 C 20.902344 18.613281 19.371094 18.765625 18.417969 19.808594 Z M 18.417969 19.808594 "/></g></svg>';
      window.mobile_logo = "<svg width='24px' height='24px' viewBox='0 0 88 88'><g stroke='none' stroke-width='1' fill='none' fill-rule='evenodd'><g fill='#0F9D58'><path d='M62,67 C62,69.761 59.761,72 57,72 L31,72 C28.239,72 26,69.761 26,67 L26,21 C26,18.239 28.239,16 31,16 L57,16 C59.761,16 62,18.239 62,21 L62,67 L62,67 Z M44,0 C19.699,0 0,19.699 0,44 C0,68.301 19.699,88 44,88 C68.301,88 88,68.301 88,44 C88,19.699 68.301,0 44,0 L44,0 Z M31,62 L57,62 L57,26 L31,26 L31,62 L31,62 Z'></path></g></g></svg>";
      var s = document.createElement('script');
      s.src = chrome.runtime.getURL('google_maps/maps_xhr.js');
      document.head.appendChild(s);


      //Local Finder
      var field = 'tbm=lcl';
      var url = window.location.href;
      if (url.indexOf(field) != -1) {

            setTimeout(function () {
                  function create_show_hide_cat_analyze_fn() {
                        if (!document.getElementById("show_hide_cat_analyze")) {
                              let gbtns = document.querySelectorAll('[class*="bcUTBf"]');
                              if (gbtns && gbtns.length > 0) {
                                    let div = document.createElement('plp');
                                    div.innerHTML += '<div style="position: absolute;top: 0;right: 0;margin-top: 20px" class="bcUTBf" id="show_hide_cat_analyze"><div><div class="F7IIOc" role="button"><div class="Ae7FMe"><span class="WaZi0e OSrXXb">Analyze Categories</span> <span id="category_analyze_counter" class="WaZi0e OSrXXb"></span></div></div></div></div>';
                                    gbtns[0].parentElement.append(div);

                                    var analyze_btn = document.getElementById("show_hide_cat_analyze");
                                    analyze_btn.addEventListener('click', show_hide_cat_analyze_fn, false);
                              }
                        }
                  }

                  function show_hide_cat_analyze_fn() {
                        let x = document.getElementById("category_results");
                        if (!x) {
                              return;
                        }
                        if (x.style.display === "none") {
                              x.style.display = "block";
                        } else {
                              x.style.display = "none";
                        }
                  }

                  //All CIDs
                  function analyze_local_finder_categories_fn() {

                        all_cids_el = document.querySelectorAll('[data-cid]');
                        all_cids = [];
                        toSendBig = [];
                        if (all_cids_el.length > 1) {
                              for (i = 0; i < all_cids_el.length; i++) {
                                    //console.log(all_cids_el[i].attributes['data-cid'].value);
                                    all_cids.push(all_cids_el[i].attributes['data-cid'].value);
                              }

                              var runRequests = function (arr_index) {
                                    let percentReady = arr_index / all_cids_el.length * 100;
                                    document.getElementById("category_analyze_counter").textContent = percentReady.toFixed(0) + '%';

                                    if (all_cids.length === arr_index) {
                                          document.getElementById("show_hide_cat_analyze").style.display = 'block';

                                          document.dispatchEvent(new CustomEvent('PLP_local_finder_analyze_results', {
                                                detail: toSendBig
                                          }));
                                          return;
                                    }
                                    var s_cid = all_cids[arr_index];
                                    if (!s_cid) {
                                          return;
                                    }
                                    var xhr = new XMLHttpRequest();

                                    xhr.open("GET", "https://" + window.location.host + "/maps/?hl=en&cid=" + s_cid);
                                    xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                                    xhr.send();
                                    xhr.onreadystatechange = function () {
                                          if (xhr.readyState === 4) {
                                                var tempToSend = encodeURIComponent(xhr.response);
                                                if (tempToSend.indexOf("window.APP_INITIALIZATION_STATE") !== -1) {
                                                      //Should cut part of the response
                                                      var splited = tempToSend.split("window.APP_INITIALIZATION_STATE");
                                                      if (splited.length === 2) {

                                                            let params = (new URL(document.location)).searchParams;
                                                            let q = params.get("q");
                                                            var xhr2 = new XMLHttpRequest();
                                                            xhr2.open("POST", 'https://chrome.pleper.com/analyzer.php', true);
                                                            xhr2.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

                                                            xhr2.send('&q=' + q + '&response_single_place_local_finder=' + '"window.APP_INITIALIZATION_STATE' + encodeURIComponent(splited[1]));
                                                            xhr2.onreadystatechange = function () {
                                                                  if (xhr2.readyState === 4) {
                                                                        let listing_data = JSON.parse(xhr2.response);
                                                                        if (listing_data.export_hash) {
                                                                              toSendBig.push(listing_data.export_hash);
                                                                        }
                                                                  }
                                                            }
                                                      }
                                                }
                                                runRequests(++arr_index);
                                          }
                                    }
                              };
                              runRequests(0);
                        }
                  }

                  let lastRequest = 401;
                  if (window.XHRstartTime) {
                        let lastRequest = (new Date()).getTime() - window.XHRstartTime;
                  }

                  window.XHRstartTime = (new Date()).getTime();

                  if (lastRequest > 400) {
                        create_show_hide_cat_analyze_fn();
                        analyze_local_finder_categories_fn();
                  }
            }, 500);
      }

      //Some settings
      if (typeof window.plpslisting_data_value_kg === 'undefined') {
            chrome.storage.sync.get(['removedContextMenu'], function (list) {
                  if (list['removedContextMenu']) {
                        window.plpslisting_data_value_kg = contains.call(list['removedContextMenu'], "slisting_data_value_kg");
                  }
            });
      }

      //Check KG panel
      setTimeout(function () {
            if (window.plpslisting_data_value_kg !== true) {
                  //data-attrid="kc:/local:pending edits"
                  function get_kg_listing_details() {
                        //PLACE ID from html source
                        var placeIDUn = document.body.innerHTML.match(/<[^<]+data-place-id=['"](Ch[^'"]+)['"][^>]+>/);
                        if (!placeIDUn) {
                              var FIDUn = document.body.innerHTML.match(/<[^<]+data-fid=['"]([^'"]+)['"][^>]+>/);
                              if (FIDUn && FIDUn.length > 0) {
                                    var FID = FIDUn[1];
                              }
                        }
                        if ((placeIDUn && placeIDUn.length > 0) || FID && FID.length > 0) {
                              var xhr = new XMLHttpRequest();
                              if (placeIDUn && placeIDUn.length > 0) {
                                    var placeID = placeIDUn[1];
                                    xhr.open("GET", "https://" + window.location.host + "/maps/place/?q=place_id:" + placeID);
                              } else {
                                    xhr.open("GET", "https://" + window.location.host + "/maps?ftid=" + FID);
                              }
                              xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                              xhr.send();
                              xhr.onreadystatechange = function () {
                                    if (xhr.readyState === 4) {
                                          var toSend = encodeURIComponent(xhr.response);
                                          if (toSend.indexOf("window.APP_INITIALIZATION_STATE") !== -1) {
                                                //Should cut part of the response
                                                var splited = toSend.split("window.APP_INITIALIZATION_STATE");
                                                if (splited.length === 2) {
                                                      toSend = "window.APP_INITIALIZATION_STATE" + splited[1];
                                                }
                                          }

                                          setTimeout(function () {
                                                document.dispatchEvent(new CustomEvent('PLP_single_place_kg_connectExtension', {
                                                      detail: toSend
                                                }));
                                          }, 0);
                                    }
                              }
                        }
                  }

                  var is_kg_panel = document.getElementsByClassName("knowledge-panel");
                  var is_kg_panel_2 = document.getElementsByClassName("kp-wholepage");
                  if (is_kg_panel_2.length > 0 || is_kg_panel.length > 0) {
                        var kg_row_with_btns_for_check = document.querySelectorAll('[data-attrid="kc:/local:unified_actions"]');
                        var kg_row_with_btns = document.querySelectorAll('[ssk*="1"]');
                        var kg_top_btn_panel = document.getElementsByClassName("duf-h");
                        if (kg_row_with_btns_for_check.length > 0 && kg_row_with_btns.length > 0) {
                              var node = document.createElement("div");
                              node.innerHTML = "<a href='#' class='Od1FEc n1obkb' role='button' ><button class='aep93e ggc73c'><span class='PbOY2e'>Listing Details</span></button></a>";
                              node.setAttribute("id", "analyze_kg_listing_details");
                              //node.setAttribute("class", "UXbvIb");
                              kg_row_with_btns[0].parentNode.appendChild(node);
                              var analyze_btn = document.getElementById("analyze_kg_listing_details");
                              analyze_btn.addEventListener('click', get_kg_listing_details, false);
                        } else {
                              if (kg_top_btn_panel.length > 0) {
                                    if (kg_top_btn_panel.length > 13) {
                                          if (kg_top_btn_panel[2].innerHTML.indexOf('maps/dir') > -1) {
                                                var index_top_btn = 2;
                                          } else {
                                                var index_top_btn = 1;
                                          }

                                    } else {
                                          var index_top_btn = 1;
                                    }
                                    var node = document.createElement("div");
                                    node.innerHTML = "<a class='ab_button'>Listing Details</a>";
                                    node.setAttribute("id", "analyze_kg_listing_details");
                                    node.setAttribute("class", "QqG1Sd");
                                    kg_top_btn_panel[index_top_btn].appendChild(node);
                                    var analyze_btn = document.getElementById("analyze_kg_listing_details");
                                    analyze_btn.addEventListener('click', get_kg_listing_details, false);
                              }
                        }

                  }
            }
      }, 1500);

      function pleper_get_user_lists(export_hash, btn_second_part_id, search_data, window_style = 1) {
            try {
                  chrome.storage.sync.get(['plpToolsApiKey', 'plpToolsApiSig'], function (val) {
                        if (!val['plpToolsApiKey']) {
                              if (window.confirm('You need API key to save listings. Open PlePer.com and get one?')) {
                                    window.open('https://pleper.com/index.php?do=api_key_sig', '_blank');
                              }
                              return;
                        }
                        if (val['plpToolsApiKey']) {
                              var apiKeyValue = val['plpToolsApiKey'];
                        }
                        if (val['plpToolsApiSig']) {
                              var apiSigValue = val['plpToolsApiSig'];
                        }
                        var hash_for_check = (sha1(JSON.stringify({'action': 'get_lists', 'api-sig': apiSigValue, 'export_hash': export_hash})));
                        var xhr = new XMLHttpRequest();
                        xhr.open("POST", 'https://chrome.pleper.com/save_to_pleper.php', true);
                        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                        xhr.send('ff=' + encodeURIComponent(JSON.stringify({'action': 'get_lists', 'api-key': apiKeyValue, 'api-hash': hash_for_check, 'export_hash': export_hash})));
                        xhr.onreadystatechange = function () {
                              if (xhr.readyState === 4) {
                                    var postResult = JSON.parse(xhr.response);
                                    all_cids = [];
                                    var theNumber = 0;
                                    if (postResult.status === 'OK') {
                                          var innerHTMLLists = '';
                                          var innerHTMLCheckboxes = '';
                                          if (document.getElementById('plp_user_lists') !== null) {
                                                document.getElementById('plp_user_lists').remove();
                                          }
                                          if (postResult.data) {
                                                for (i = 0; i < postResult.data.length; i++) {
                                                      innerHTMLLists += "<option value='" + postResult.data[i].id + "' class='plp_user_lists'>" + postResult.data[i].name + " (" + postResult.data[i].cids_count + ")</option>";
                                                }
                                                var style_new_list_tr = 'none';
                                          } else {
                                                var style_new_list_tr = 'table-row';
                                          }
                                          innerHTMLLists += "<option value='new' class='plp_user_lists'>* Create new list</option>";


                                          if (search_data) {
                                                if (search_data.name) {
                                                      innerHTMLCheckboxes += "<tr><td colspan='2'><label><input class='plp_listings_to_save' type='checkbox' checked value='" + search_data.cid + "'> " + search_data.name + "</label></td></tr><tr>"
                                                } else {
                                                      for (let i = 0; i < search_data.length + 1; i++) {
                                                            plp_index = i + 1;
                                                            if (typeof (search_data[plp_index]) !== 'undefined' && typeof (search_data[plp_index]['cid']) !== 'undefined') {
                                                                  if (all_cids.includes(search_data[plp_index]['cid']) === false) {
                                                                        theNumber++;
                                                                        all_cids.push(search_data[plp_index]['cid']);
                                                                        if (typeof search_data[plp_index] !== 'undefined' && typeof search_data[plp_index]['name'] !== 'undefined') {
                                                                              innerHTMLCheckboxes += "<tr><td colspan='2'><label><input class='plp_listings_to_save' type='checkbox' checked value='" + search_data[plp_index]['cid'] + "'> " + theNumber + ". " + search_data[plp_index]['name'] + "</label></td></tr><tr>";
                                                                        }
                                                                  }
                                                            }
                                                      }
                                                }
                                          }

                                          var node = document.createElement("div");
                                          node.innerHTML = "<table style='padding: 5px;float: left;width: 100%;border-spacing: 0px'><tr><td>List: <span class='select-dropdown'><select name='plp_user_lists' id='plp_user_lists_select' style='width:300px'>" + innerHTMLLists + "</select></span></td><td><a href='javascript:void()' id='plp_add_to_list_close_btn'>X</a></td></tr><tr id='plp_new_list_name_tr' style='display:" + style_new_list_tr + "'><td colspan='2'><input type='text' name='plp_new_list_name' id='plp_new_list_name' value='' placeholder='Enter list name' style='background-color: #E6E6E6;width: 333px;padding: 5px;margin:5px 0;border-radius: 4px;    border-color: #fff;border-style: solid;color:#000'><br><button style='padding: 1px 6px;width:343px' id='plp_create_new_list_btn' class='plp_nav_btns'><a style='color:#fff' target='_blank'>Create List</a></button></td></tr><tr><td colspan='2'><hr></td></tr>" + innerHTMLCheckboxes + "<tr><td><hr></td></tr><tr><td colspan='2'><button style='padding: 1px 6px;width:95%' id='plp_save_cids_to_list' class='plp_nav_btns'><a style='color:#fff' target='_blank'>Save</a></button></td></tr></table>" + '<style>.select-dropdown,.select-dropdown * { color:#000; margin: 0; padding: 5px; position: relative; box-sizing: border-box;}.select-dropdown { position: relative; background-color: #E6E6E6; border-radius: 4px;}.select-dropdown select { font-size: 1rem; font-weight: normal; max-width: 100%; padding: 8px 24px 8px 10px; border: none; background-color: transparent; -webkit-appearance: none; -moz-appearance: none; appearance: none;}.select-dropdown select:active, .select-dropdown select:focus { outline: none; box-shadow: none;}.select-dropdown:after { content: ""; position: absolute; top: 50%; right: 8px; width: 0; height: 0; margin-top: -2px; border-top: 5px solid #aaa; border-right: 5px solid transparent; border-left: 5px solid transparent;} #plp_user_lists hr{background: #e6e6e6;border: none;height: 1px;margin: 8px 0;}</style>';

                                          node.style.position = 'fixed';
                                          if (document.documentElement.dir === 'rtl') {
                                                if (window_style === 1) {
                                                      node.style.left = '347px';
                                                } else if (window_style === 2 || window_style === 3) {
                                                      node.style.left = '365px';
                                                }
                                          } else {
                                                if (window_style === 1 || window_style === 4) {
                                                      node.style.right = '347px';
                                                } else if (window_style === 2 || window_style === 3) {
                                                      node.style.right = '365px';
                                                }
                                          }

                                          if (window_style === 1 || window_style === 3) {
                                                node.style.top = '70px';
                                          } else if (window_style === 2) {
                                                node.style.top = '20%';

                                          } else if (window_style === 4) {
                                                node.style.top = '155px';
                                          }
                                          calcedHeight = 78;
                                          node.style.overflow = 'auto';
                                          //node.style.height = calcedHeight + '%';
                                          node.style.width = '375px';
                                          node.style.backgroundColor = '#fff';
                                          node.style.color = '#4d7496';
                                          node.style.padding = '5px';
                                          node.style.boxShadow = '-5px 5px rgb(0, 0, 0, 0.05';
                                          node.style.fontFamily = 'arial,sans-serif';
                                          node.style.zIndex = '9999';
                                          node.style.display = 'block';
                                          node.setAttribute("id", "plp_user_lists");
                                          document.body.appendChild(node);

                                          document.getElementById('plp_save_cids_to_list').addEventListener('click', function () {
                                                pleper_save_cids_to_list(export_hash, btn_second_part_id, search_data, window_style);
                                          }, false);
                                          document.getElementById('plp_add_to_list_close_btn').addEventListener('click', function () {
                                                document.getElementById('plp_user_lists').remove();
                                          }, false);

                                          document.getElementById('plp_user_lists_select').addEventListener('change', function () {
                                                if (this.value === 'new') {
                                                      document.getElementById('plp_new_list_name_tr').style.display = "table-row";
                                                } else {
                                                      document.getElementById('plp_new_list_name_tr').style.display = "none";
                                                }
                                          });

                                          document.getElementById('plp_create_new_list_btn').addEventListener('click', function () {
                                                if (document.getElementById('plp_new_list_name').value === "") {
                                                      var new_list_name = 'New List';
                                                } else {
                                                      var new_list_name = document.getElementById('plp_new_list_name').value;
                                                }
                                                pleper_create_user_lists(new_list_name, export_hash, search_data, window_style);
                                          });


                                    } else if (postResult.errors) {
                                          alert(postResult.errors);
                                    }
                              }
                        }
                  });
            } catch (err) {
                  console.log('PLP Error: PLP_single_place_local_finder_connectExtension: ');
                  console.log(err);
      }
      }

      function pleper_create_user_lists(list_name, export_hash, search_data, window_style) {
            try {
                  chrome.storage.sync.get(['plpToolsApiKey', 'plpToolsApiSig'], function (val) {

                        if (val['plpToolsApiKey']) {
                              var apiKeyValue = val['plpToolsApiKey'];
                        }
                        if (val['plpToolsApiSig']) {
                              var apiSigValue = val['plpToolsApiSig'];
                        }
                        var hash_for_check = (sha1(JSON.stringify({'action': 'create_list', 'api-sig': apiSigValue, 'export_hash': export_hash})));
                        var xhr = new XMLHttpRequest();
                        xhr.open("POST", 'https://chrome.pleper.com/save_to_pleper.php', true);
                        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                        var currentURL = window.location.href;
                        xhr.send('ff=' + encodeURIComponent(JSON.stringify({'action': 'create_list', 'list_name': list_name, 'api-key': apiKeyValue, 'api-hash': hash_for_check, 'export_hash': export_hash})));
                        xhr.onreadystatechange = function () {
                              if (xhr.readyState === 4) {
                                    var postResult = JSON.parse(xhr.response);
                                    if (postResult.status === 'OK') {
                                          pleper_get_user_lists(export_hash, export_hash, search_data, window_style);
                                    } else if (postResult.errors) {
                                          alert(postResult.errors);
                                    }
                              }
                        }
                  });
            } catch (err) {
                  console.log('PLP Error: PLP_single_place_local_finder_connectExtension: ');
                  console.log(err);
            }
      }
      function pleper_get_list_by_cid(cid) { //, search_data, window_style
            try {
                  chrome.storage.sync.get(['plpToolsApiKey', 'plpToolsApiSig'], function (val) {

                        if (val['plpToolsApiKey']) {
                              var apiKeyValue = val['plpToolsApiKey'];
                        }
                        if (val['plpToolsApiSig']) {
                              var apiSigValue = val['plpToolsApiSig'];
                        }
                        var hash_for_check = (sha1(JSON.stringify({'action': 'get_lists_by_cid', 'api-sig': apiSigValue, 'cid': cid})));
                        var xhr = new XMLHttpRequest();
                        xhr.open("POST", 'https://chrome.pleper.com/save_to_pleper.php', true);
                        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                        var currentURL = window.location.href;
                        xhr.send('ff=' + encodeURIComponent(JSON.stringify({'action': 'get_lists_by_cid', 'api-key': apiKeyValue, 'api-hash': hash_for_check, 'cid': cid})));
                        xhr.onreadystatechange = function () {
                              if (xhr.readyState === 4) {
                                    var postResult = JSON.parse(xhr.response);
                                    if (postResult.status === 'OK') {
                                          if (typeof (postResult.data) === 'object' && postResult.data !== null) {
                                                document.getElementById('chrome_lists_row_td').innerHTML = postResult.data.join('<br>');
                                          } else {
                                                document.getElementById('chrome_lists_row_td').innerHTML = 'None';
                                          }

                                    } else if (postResult.errors) {
                                          alert(postResult.errors);
                                    }
                              }
                        }
                  });
            } catch (err) {
                  console.log('PLP Error: PLP_single_place_local_finder_connectExtension: ');
                  console.log(err);
            }
      }

      function pleper_save_cids_to_list(export_hash, btn_second_part_id, search_data, window_style) {
            try {
                  chrome.storage.sync.get(['plpToolsApiKey', 'plpToolsApiSig'], function (val) {
                        all_cids = [];
                        if (val['plpToolsApiKey']) {
                              var apiKeyValue = val['plpToolsApiKey'];
                        }
                        if (val['plpToolsApiSig']) {
                              var apiSigValue = val['plpToolsApiSig'];
                        }

                        var cidsCheckboxes = document.querySelectorAll('.plp_listings_to_save');

                        var cidsToSave = '';
                        for (i = 0; i < cidsCheckboxes.length; i++) {
                              if (cidsCheckboxes[i].checked === true) {
                                    cidsToSave += '|' + cidsCheckboxes[i].value;
                                    all_cids.push(cidsCheckboxes[i].value);
                              }
                        }

                        var plpListsSelect = document.querySelectorAll('.plp_user_lists');
                        for (i = 0; i < plpListsSelect.length; i++) {
                              if (plpListsSelect[i].selected === true) {
                                    var list_id = plpListsSelect[i].value;
                                    i = 100;
                              }
                        }

                        var hash_for_check = (sha1(JSON.stringify({'action': 'add_to_list', 'api-sig': apiSigValue, 'export_hash': cidsToSave})));
                        var xhr = new XMLHttpRequest();
                        xhr.open("POST", 'https://chrome.pleper.com/save_to_pleper.php', true);
                        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                        var currentURL = window.location.href;
                        xhr.send('ff=' + encodeURIComponent(JSON.stringify({'action': 'add_to_list', 'list_id': list_id, 'api-key': apiKeyValue, 'api-hash': hash_for_check, 'export_hash': cidsToSave})));
                        xhr.onreadystatechange = function () {
                              if (xhr.readyState === 4) {
                                    var postResult = JSON.parse(xhr.response);
                                    if (postResult.status === 'OK') {
                                          document.getElementById('save_to_plaper_btn' + btn_second_part_id).innerHTML = "Saved !";
                                          setTimeout(function () {
                                                if (document.getElementById('plp_user_lists') !== null) {
                                                      document.getElementById('plp_user_lists').remove();
                                                }
                                          }, 1500);
                                          if (window_style === 1) {
                                                var runRequests = function (arr_index) {
                                                      if (all_cids.length === arr_index) {
                                                            return;
                                                      }
                                                      var s_cid = all_cids[arr_index];
                                                      var xhr = new XMLHttpRequest();
                                                      xhr.open("GET", "https://" + window.location.host + "/maps/?cid=" + s_cid);
                                                      xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                                                      xhr.send();
                                                      xhr.onreadystatechange = function () {
                                                            if (xhr.readyState === 4) {
                                                                  var tempToSend = encodeURIComponent(xhr.response);
                                                                  if (tempToSend.indexOf("window.APP_INITIALIZATION_STATE") !== -1) {
                                                                        //Should cut part of the response
                                                                        var splited = tempToSend.split("window.APP_INITIALIZATION_STATE");
                                                                        if (splited.length === 2) {
                                                                              let params = (new URL(document.location)).searchParams;
                                                                              let q = params.get("q");
                                                                              var xhr2 = new XMLHttpRequest();
                                                                              xhr2.open("POST", 'https://chrome.pleper.com/analyzer.php', true);
                                                                              xhr2.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

                                                                              xhr2.send('&q=' + q + '&response_single_place_local_finder=' + '"window.APP_INITIALIZATION_STATE' + encodeURIComponent(splited[1]));
                                                                              xhr2.onreadystatechange = function () {
                                                                                    if (xhr2.readyState === 4) {

                                                                                    }
                                                                              }
                                                                        }
                                                                  }
                                                                  runRequests(++arr_index);
                                                            }
                                                      }
                                                };
                                                runRequests(0);
                                          }
                                    } else if (postResult.errors) {
                                          alert(postResult.errors);
                                    }
                              }
                        }
                  });
            } catch (err) {
                  console.log('PLP Error: PLP_single_place_local_finder_connectExtension: ');
                  console.log(err);
            }
      }

      chrome.storage.sync.get(['plpToolsApiKey', 'plpToolsApiSig'], function (val) {
            if (val['plpToolsApiKey']) {
                  window.apiKeyValue = val['plpToolsApiKey'];
            }
            if (val['plpToolsApiSig']) {
                  window.apiSigValue = val['plpToolsApiSig'];
            }
      })

      //Analyze  Search Results from localfinder -> next page
      document.addEventListener('PLP_local_finder_analyze_results_next_page', function (e) {
            all_cids_el = document.querySelectorAll('[data-cid]');
            all_cids = [];
            toSendBig = [];
            if (all_cids_el.length > 1) {
                  for (i = 0; i < all_cids_el.length; i++) {
                        all_cids.push(all_cids_el[i].attributes['data-cid'].value);
                  }
                  var runRequests = function (arr_index) {
                        let percentReady = arr_index / all_cids_el.length * 100;
                        document.getElementById("category_analyze_counter").textContent = percentReady.toFixed(0) + '%';

                        if (all_cids.length === arr_index) {
                              document.dispatchEvent(new CustomEvent('PLP_local_finder_analyze_results', {
                                    detail: toSendBig
                              }));
                              return;
                        }
                        var s_cid = all_cids[arr_index];
                        var xhr = new XMLHttpRequest();
                        xhr.open("GET", "https://" + window.location.host + "/maps/?cid=" + s_cid);
                        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                        xhr.send();
                        xhr.onreadystatechange = function () {
                              if (xhr.readyState === 4) {
                                    var tempToSend = encodeURIComponent(xhr.response);
                                    if (tempToSend.indexOf("window.APP_INITIALIZATION_STATE") !== -1) {
                                          //Should cut part of the response
                                          var splited = tempToSend.split("window.APP_INITIALIZATION_STATE");
                                          if (splited.length === 2) {

                                                let params = (new URL(document.location)).searchParams;
                                                let q = params.get("q");
                                                var xhr2 = new XMLHttpRequest();
                                                xhr2.open("POST", 'https://chrome.pleper.com/analyzer.php', true);
                                                xhr2.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

                                                xhr2.send('&q=' + q + '&response_single_place_local_finder=' + '"window.APP_INITIALIZATION_STATE' + encodeURIComponent(splited[1]));
                                                xhr2.onreadystatechange = function () {
                                                      if (xhr2.readyState === 4) {
                                                            let listing_data = JSON.parse(xhr2.response);
                                                            if (listing_data.export_hash) {
                                                                  toSendBig.push(listing_data.export_hash);
                                                            }
                                                      }
                                                }
                                          }
                                    }
                                    runRequests(++arr_index);
                              }
                        }
                  };
                  runRequests(0);
            }
      });

      //Analyze Search Results from local finder
      document.addEventListener('PLP_local_finder_analyze_results', function (e) {
            try {
                  var xhr = new XMLHttpRequest();
                  xhr.open("POST", 'https://chrome.pleper.com/analyzer.php', true);
                  xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                  //3 MB!@#!

                  xhr.send('&u=' + encodeURIComponent(window.location.href) + '&response_results_local_finder=' + encodeURIComponent(JSON.stringify(e.detail)));
                  xhr.onreadystatechange = function () {
                        if (xhr.readyState === 4) {
                              if (xhr.response) {
                                    var search_data = JSON.parse(xhr.response);
                                    //When the single place is part of search results ... identify whet is is At This Place : ( 
                                    var current_url = decodeURIComponent(window.location.href);
                                    //Only the search result analyze div on the right
                                    setTimeout(function () {
                                          let total_result_returned = search_data.length;
                                          var cats_total = {'Total Categories': 0};

                                          for (let i = 0; i < total_result_returned; i++) {
                                                plp_index = i + 1;
                                                if (typeof search_data[plp_index] !== 'undefined' && typeof search_data[plp_index]['name'] !== 'undefined') {
                                                      //Category Analyze
                                                      if (search_data[plp_index]['categories']) {
                                                            search_data[plp_index]['categories'].forEach(function (singleCat) {
                                                                  if (!cats_total[singleCat]) {
                                                                        cats_total[singleCat] = 0;
                                                                  }
                                                                  cats_total['Total Categories']++;
                                                                  cats_total[singleCat]++;
                                                            });
                                                      }
                                                }
                                          }


                                          //The info window with categories and reviews analyze
                                          if (typeof cats_total === 'object' && cats_total !== null && cats_total['Total Categories'] > 1) {
                                                //Remove the old window with cat analyze
                                                if (document.getElementById("category_results") !== null) {
                                                      document.getElementById("category_results").remove();
                                                }
                                                //Destroy save to pleper window
                                                if (document.getElementById('plp_user_lists') !== null) {
                                                      document.getElementById('plp_user_lists').remove();
                                                }

                                                if (document.documentElement.dir === 'rtl') {
                                                      var innerHTML = '<div id="plp_btns" style="position:fixed;top:155px;left:0px;width:375px;"><button type="button" class="category_analyze_show_hide" id="my_js_sucks_categories">Categories</button>';
                                                } else {
                                                      var innerHTML = '<div id="plp_btns" style="position:fixed;top:155px;right:0px;width:365px;"><button type="button" class="category_analyze_show_hide" id="my_js_sucks_categories">Categories</button>';
                                                }

                                                innerHTML += '<button type="button" class="reviews_analyze_show_hide" id="my_js_sucks_reviews">Reviews</button>';
                                                innerHTML += '<button type="button" class="attributes_analyze_show_hide" id="my_js_sucks_attributes">Attributes</button>';
                                                innerHTML += '<button type="button" class="next_cool_thing_show_hide" id="my_js_sucks_next">Business Hours</button></div>';

                                                //Purify the innerHTML for additional safety
                                                if (search_data[0]['export_hash']) {
                                                      innerHTML += '<button type="button" class="plp_nav_btns" id="save_to_plaper_btn' + search_data[0]['cids'] + '" style="padding: 1px 6px;width:33%"><a target="_blank" style="color:#fff">Save</a></button>';
                                                      innerHTML += '</div><button type="button" class="plp_nav_btns" style="padding: 1px 6px;width:33%"><a target="_blank" style="color:#fff" href="https://chrome.pleper.com/export.php?hash=' + search_data[0]['export_hash'] + '&nc=' + Date.now() + '">Export</a></button>';
                                                      innerHTML += '<button type="button" class="plp_nav_btns" id="close_category_results" style="padding: 1px 6px;width:32%">Close</button>';

                                                } else {
                                                      innerHTML += '<button type="button" class="plp_nav_btns" id="save_to_plaper_btn' + search_data[0]['cids'] + '" style="padding: 1px 6px;width:24%"><a target="_blank" style="color:#fff">Save</a></button>';
                                                      innerHTML += '<button type="button" class="plp_nav_btns" id="close_category_results" style="padding: 1px 6px;width:24%">Close</button>';
                                                }

                                                innerHTML += '<div id="plp_table_analyzes">';

                                                if (search_data[0].br_flux) {
                                                      innerHTML += search_data[0].br_flux;
                                                }

                                                //Category analyze
                                                if (typeof search_data[0] !== 'undefined' && typeof search_data[0]['category_analyze_table'] !== 'undefined') {
                                                      //innerHTML += search_data[0]['additional_info_table'];
                                                      innerHTML += DOMPurify.sanitize(search_data[0]['category_analyze_table'], {ALLOWED_TAGS: ['a', 'target', 'table', 'br', 'strong', 'td', 'tr', 'td'], ALLOWED_ATTR: ['a', 'href', 'target', 'style', 'class', 'id', 'colspan', 'rel']});
                                                }

                                                //Review analyze
                                                if (typeof search_data[0] !== 'undefined' && typeof search_data[0]['review_analyze_table'] !== 'undefined') {
                                                      innerHTML += '<br>' + DOMPurify.sanitize(search_data[0]['review_analyze_table'], {ALLOWED_TAGS: ['table', 'br', 'strong', 'td', 'tr', 'td'], ALLOWED_ATTR: ['style', 'class', 'id', 'colspan', 'rel']});
                                                }

                                                //Atributes analyze
                                                if (typeof search_data[0] !== 'undefined' && typeof search_data[0]['attribute_analyze_table'] !== 'undefined') {
                                                      innerHTML += '<br>' + DOMPurify.sanitize(search_data[0]['attribute_analyze_table'], {ALLOWED_TAGS: ['table', 'br', 'strong', 'td', 'tr', 'td'], ALLOWED_ATTR: ['style', 'class', 'id', 'colspan', 'rel']});
                                                }

                                                //Business hours analyze
                                                if (typeof search_data[0] !== 'undefined' && typeof search_data[0]['business_hours_table'] !== 'undefined') {
                                                      innerHTML += '<br>' + DOMPurify.sanitize(search_data[0]['business_hours_table'], {ALLOWED_TAGS: ['table', 'br', 'strong', 'td', 'tr', 'td'], ALLOWED_ATTR: ['style', 'class', 'id', 'colspan']});
                                                }

                                                innerHTML += '<h3 class="next_cool_thing" style="text-align:center;width:90%;">Suggestion at dev@pleper.com : )</h3>';

                                                //?
                                                var calcedHeight = 15 * 3.2;
                                                calcedHeight += 20;

                                                //Create Info Window
                                                var node = document.createElement("div");
                                                node.innerHTML = DOMPurify.sanitize(innerHTML, {ALLOWED_TAGS: ['table', 'h3', 'br', 'strong', 'td', 'tr', 'td', 'button', 'a', 'div'], ALLOWED_ATTR: ['href', 'target', 'style', 'id', 'class', 'id', 'colspan', 'onclick']});
                                                node.style.position = 'fixed';
                                                if (document.documentElement.dir === 'rtl') {
                                                      node.style.left = '0px';
                                                } else {
                                                      node.style.right = '0px';
                                                }
                                                node.style.top = '217px';
                                                if (calcedHeight < 15) {
                                                      calcedHeight = 15;
                                                }
                                                if (calcedHeight > 100) {
                                                      calcedHeight = 78;
                                                      node.style.overflow = 'auto';
                                                }
                                                node.style.height = calcedHeight + '%';
                                                node.style.width = '355px';
                                                node.style.backgroundColor = '#fff';
                                                node.style.color = '#4d7496';
                                                node.style.padding = '5px';
                                                node.style.overflow = 'scroll';
                                                node.style.overflowX = 'hidden';
                                                node.style.boxShadow = '-5px 5px rgb(0, 0, 0, 0.05';
                                                node.style.fontFamily = 'arial,sans-serif';
                                                node.style.zIndex = '9999';
                                                node.style.display = 'none';
                                                node.setAttribute("id", "category_results");
                                                node.setAttribute("class", "scrollable-x");
                                                document.body.appendChild(node);

                                                setTimeout(function () {
                                                      //EventListener for show user lists and Save to pleper

                                                      if (document.getElementById('save_to_plaper_btn' + search_data[0]['cids'])) {
                                                            document.getElementById('save_to_plaper_btn' + search_data[0]['cids']).addEventListener('click', function () {
                                                                  pleper_get_user_lists(search_data[0]['cids'], search_data[0]['cids'], search_data, 4);
                                                            }, false);
                                                      }

                                                      if (document.getElementById('close_category_results')) {
                                                            document.getElementById('close_category_results').addEventListener('click', function () {
                                                                  let x = document.getElementById("category_results");
                                                                  if (!x) {
                                                                        return;
                                                                  }
                                                                  if (x.style.display === "none") {
                                                                        x.style.display = "block";
                                                                  } else {
                                                                        x.style.display = "none";
                                                                  }
                                                            }, false);
                                                      }

                                                }, 2000);

                                                var node = document.createElement("style");
                                                node.innerHTML = '.red_name{color:#a20000; fotn-weight:600} .category_analyze_show_hide,.next_cool_thing_show_hide, .reviews_analyze_show_hide, .attributes_analyze_show_hide {background-image: none;filter: none;box-shadow: none;padding: 7px 13px;font-weight: 400;border: 1px solid rgba(0,0,0,0.13);border-radius: 0;position: relative;background-color: #3968c6;z-index: 2;color:#fff;width:50%;}.category_analyze_table, .review_analyze_table, .attributes_analyze_table, .next_cool_thing, .business_hours_analyze_table {display:block} .hide_table {display:none !important}';

                                                document.body.appendChild(node);

                                                document.querySelector('.category_analyze_show_hide').addEventListener('click', function (e) {
                                                      document.querySelector("#plp_cat_analyze_table").scrollIntoView({behavior: "smooth", block: "start", inline: "nearest"});

                                                });
                                                document.querySelector('.reviews_analyze_show_hide').addEventListener('click', function (e) {
                                                      document.querySelector("#plp_review_analyze_table").scrollIntoView({behavior: "smooth", block: "start", inline: "nearest"});
                                                });
                                                document.querySelector('.attributes_analyze_show_hide').addEventListener('click', function (e) {
                                                      document.querySelector("#plp_attributes_analyze_table").scrollIntoView({behavior: "smooth", block: "start", inline: "nearest"});
                                                });
                                                document.querySelector('.next_cool_thing_show_hide').addEventListener('click', function (e) {
                                                      document.querySelector("#plp_business_hours_analyze_table").scrollIntoView({behavior: "smooth", block: "start", inline: "nearest"});
                                                });
                                          }

                                    }, 50);
                              }
                        }
                  }
            } catch (err) {
                  console.log('PLP Error: PLP_single_place_local_finder_connectExtension: ');
                  console.log(err);
            }
      });

      //Knowedge graph
      document.addEventListener('PLP_single_place_kg_connectExtension', function (e) {
            try {
                  var single_listing_info_el = document.getElementsByClassName("single_listing_info_window");
                  for (var i = 0; i < single_listing_info_el.length; i++) {
                        single_listing_info_el[i].remove();
                  }
                  //Destroy save to pleper window
                  if (document.getElementById('plp_user_lists')) {
                        document.getElementById('plp_user_lists').remove();
                  }

                  var xhr = new XMLHttpRequest();
                  xhr.open("POST", 'https://chrome.pleper.com/analyzer.php', true);
                  xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                  xhr.send('&response_single_place_local_finder=' + encodeURIComponent(JSON.stringify(e.detail)));
                  xhr.onreadystatechange = function () {
                        if (xhr.readyState === 4) {
                              var listing_data = JSON.parse(xhr.response);
                              CID = listing_data.cid;
                              let verified_emoji = ['<a href="https://business.google.com/create?fp=' + CID + '" target="_blank">&#10060; Not Verified</a>', '<a href="https://business.google.com/create?fp=' + CID + '" target="_blank" >&#9989; Verified</a>'];
                              if (listing_data.name) {
                                    CID = listing_data.cid;
                                    if (listing_data.categories) {
                                          var cat_number = listing_data.categories.length;
                                    }
                                    if (cat_number > 2) {
                                          var show_cat_count = '<br>(<strong>' + cat_number + '</strong>)';
                                    } else {
                                          var show_cat_count = '';
                                    }

                                    if (listing_data.review_count == null) {
                                          listing_data.review_count = '';
                                    }
                                    if (listing_data.rating == null) {
                                          listing_data.rating = '';
                                    }
                                    if (listing_data.address == null) {
                                          listing_data.address = 'hidden';
                                    }

                                    var innerHTML = "<table style='color: rgb(77, 116, 150);overflow: hidden scroll;background-color:#fff;font-size: 15px;' id='plp_slisting_info'><tr style='border-bottom: 2px solid #e6e6e6;border-top: 1px solid #e6e6e6;font-weight:600;text-align:center;font-size:15px'><td colspan='2'><strong>" + listing_data.name + "</strong> <small>" + verified_emoji[listing_data.verified] + "</small></td></tr>";
                                    if (listing_data.categories) {
                                          innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Categories" + show_cat_count + "</td><td>" + listing_data.categories.join(', ') + "</td></tr>";
                                    }

                                    if (window.apiKeyValue) {
                                          innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;' id='chrome_lists_row'><td style='padding:5px;font-weight:600'>Competitor Lists</td><td id='chrome_lists_row_td'></td></tr>";
                                    }

                                    innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Place ID</td><td data-pid='" + listing_data.place_id + "' title='" + listing_data.place_id + "'>" + listing_data.place_id + "</td></tr>";
                                    innerHTML += "<tr><td style='padding:5px;font-weight:600;'>CID</td><td>" + CID + "</td></tr>";
                                    innerHTML += "<tr><td style='padding:5px;font-weight:600'>Business Profile ID</td><td>" + listing_data.business_profile_id + "</td></tr>";
                                    if (listing_data.address !== 'hidden' && listing_data.links.brightlocal) {
                                          innerHTML += "<tr class='plp_info_window_links' style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Address<br><a href='" + listing_data.links.brightlocal + "' target='_blank'  title='Check Google local search results from this listing location' rel='noreferrer noopener'>" + window.brightlocal_logo + "</a></td><td>" + listing_data.address + " </td></tr>";
                                    } else {
                                          innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Address</td><td>" + listing_data.address + "</td></tr>";
                                    }

                                    innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Phone</td><td>" + listing_data.phone_number + "</td></tr>";
                                    if (listing_data.website && listing_data.links.semrush) {
                                          innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;' class='plp_info_window_links'><td style='padding:5px;font-weight:600'>Website</td><td style='overflow-wrap: anywhere'>" + listing_data.website + "<br><a href='https://developers.google.com/speed/pagespeed/insights/?url=" + encodeURIComponent(listing_data.website) + "' target='_blank' style='float: left;height: 26px;width: 28px;'><img src='https://www.gstatic.com/images/icons/material/product/2x/pagespeed_64dp.png' title='PageSpeed Insights' width='24px'></a> <a href='https://www.google.com/webmasters/tools/mobile-friendly/?url=" + encodeURIComponent(listing_data.website) + "' target='_blank' title='Google Mobile Friendly Test' style='float: left;height: 26px;width: 28px;margin-left:10px'>" + window.mobile_logo + "</a> <a href='https://validator.schema.org/?url=" + encodeURIComponent(listing_data.website) + "' target='_blank' title='Structured Data Test' style='float: left;height: 26px;width: 28px;margin-left:10px'>" + window.schema_logo + "</a> <a href='https://pleper.com/tools/serpstats.php?url=" + encodeURIComponent(listing_data.website) + "' target='_blank' title='SerpStat Website Analyze' style='float: left;height: 26px;width: 28px;margin-left:10px'>" + window.serpsta_logo + "</a> <a href='" + listing_data.links.semrush + "' target='_blank' title='Semrush Website Analyze' style='float: left;height: 26px;width: 28px;margin-left:10px' rel='noreferrer noopener'>" + window.semrush_logo + "</a> <a href='" + listing_data.links.namecheap + "' target='_blank' title='Whois information' style='float: left;height: 26px;width: 28px;margin-left:14px' rel='noreferrer noopener'>" + window.namecheap_logo + "</a></td></tr>";
                                          //
                                    } else {
                                          innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;' class='plp_info_window_links'><td style='padding:5px;font-weight:600'>Website</td><td>-</td></tr>";
                                    }
                                    innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Reviews</td><td>" + listing_data.review_count + "</td></tr>";
                                    innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Rating</td><td>" + listing_data.rating + "</td></tr>";
                                    if (listing_data.image_count) {
                                          innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Image Count</td><td>" + listing_data.image_count + "</td></tr>";
                                    }
                                    innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Coordinates</td><td>" + listing_data.latitude.toFixed(8) + ', ' + listing_data.longitude.toFixed(8) + "</td></tr>";
                                    if (listing_data.attribute_analyze_count) {
                                          innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;' class='to_remove_from_pinned_window'><td style='padding:5px;font-weight:600'>Attributes</td><td>" + listing_data.attribute_analyze_count + " - <a id='show_hide_att' style='font-size:13px'>Show Attributes</a></td></tr>";
                                    }

                                    innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>KG ID</td><td><a href='" + listing_data.links.google_kg + "' target='_blank'>" + listing_data.kg_id + "</a></td></tr>";
                                    if (listing_data.links) {
                                          innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;' class='plp_info_window_links'><td style='padding:5px 0;font-weight:600' colspan='2'>";
                                          innerHTML += "<a href='" + listing_data.links.google_search + "' title='Google SERP Results' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.google_search_svg + "</a>";
                                          innerHTML += "<a href='" + listing_data.links.google_maps + "' title='Google Maps Link' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.google_maps_svg + "</a>";
                                          innerHTML += "<a href='" + listing_data.links.google_prolist + "' title='Google Pro List Result' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.google_guaranteed_svg + "</a>";
                                          innerHTML += "<a href='https://search.google.com/local/writereview?placeid=" + listing_data.place_id + "' title='Google Write Review Link' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.yellow_star + "</a>";
                                          innerHTML += "<a href='" + listing_data.links.bing_search + "' title='Bing Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.bing_logo_svg + "</a>";
                                          innerHTML += "<a href='" + listing_data.links.duckduckgo + "' title='Duckduckgo Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.duckduck_logo_svg + "</a>";
                                          innerHTML += "<a href='" + listing_data.links.apple_maps + "' title='Apple Maps Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.apple_maps_svg + "</a>";
                                          innerHTML += "<a href='" + listing_data.links.yelp + "' title='Yelp Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + yelp_logo_svg + "</a>";
                                          innerHTML += "<a href='" + listing_data.links.facebook_search + "' title='Facebook Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.facebook_logo + "</a>";
//                                              innerHTML += "<a href='" + listing_data.links.openstreetmap + "' title='Facebook Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>O</a>";
                                          innerHTML += "<a href='" + listing_data.links.wikipedia_article_search + "' title='Wikipedia Near By Articles' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.wikipedia_logo + "</a>";
                                          innerHTML += "<a href='" + listing_data.links.foursquare + "' title='Foursquare Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.foursquare_logo + "</a>";
                                          if (listing_data.links.sos) {
                                                innerHTML += "<a href='" + listing_data.links.sos + "' title='Secretary of State Business Lookup' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>SOS</a>";
                                          }

                                    }
                                    innerHTML += "</td></tr>";
                                    if (listing_data.br_flux) {
                                          innerHTML += "<tr><td colspan='2'>" + listing_data.br_flux + "</td></tr>";
                                    }

                                    innerHTML += "</table>";
                                    if (listing_data.attribute_analyze_table) {
                                          innerHTML += '<span class="to_remove_from_pinned_window">' + DOMPurify.sanitize(listing_data.attribute_analyze_table, {ALLOWED_TAGS: ['table', 'h3', 'h2', 'h1', 'ul', 'hr', 'li', 'br', 'strong', 'td', 'tr', 'td', 'button', 'a', 'div'], ALLOWED_ATTR: ['href', 'target', 'style', 'id', 'class', 'id', 'colspan']}) + '</span>';
                                          setTimeout(function () {
                                                if (document.getElementById("show_hide_att")) {
                                                      document.getElementById('show_hide_att').addEventListener('click', function () {
                                                            var x = document.getElementById("plp_attr_analyze");
                                                            if (x && x.style.display === "none") {
                                                                  x.style.display = "block";
                                                                  document.getElementById('show_hide_att').innerText = "Hide Attributes";
                                                            } else {
                                                                  x.style.display = "none";
                                                                  document.getElementById('show_hide_att').innerText = "Show Attributes";
                                                            }
                                                      }, false);
                                                }
                                          }, 1000);
                                    }

                                    //Check if the listing is part of chrome list
                                    if (window.apiKeyValue) {
                                          pleper_get_list_by_cid(listing_data.cid);
                                    }

                                    //Destroy The Info Window
                                    if (document.getElementById("place_id_fid_cid" + listing_data.place_id)) {
                                          setTimeout(function () {
                                                document.getElementById("place_id_fid_cid" + listing_data.place_id).remove();
                                          }, 15000);
                                    }

                                    var node = document.createElement("style");
                                    node.innerHTML = '.plp_s_info { margin-left:20px}';
                                    document.body.appendChild(node);
                                    //Remove search analyze info
                                    if (document.getElementById("category_results")) {
                                          //show_hide_category_results_again();
                                          //document.getElementById("category_results").remove();
                                          var x = document.getElementById("category_results");
                                          if (x.style.display !== "none") {
                                                x.style.display = "none";
                                          }
                                    }
                                    //Create Info Window
                                    var node = document.createElement("div");
                                    if (listing_data.export_hash) {
                                          node.innerHTML = '<button type="button" class="plp_nav_btns to_remove_from_pinned_window" id="save_to_plaper_btn' + listing_data.cid + '"><a target="_blank" style="color:#fff">Save</a></button><button type="button" class="plp_nav_btns to_remove_from_pinned_window" style="width:23%"><a target="_blank" style="color:#fff" href="https://chrome.pleper.com/export.php?hash=' + listing_data.export_hash + '&nc=' + Date.now() + '">Export</a></button>' + '<button type="button" class="plp_nav_btns to_remove_from_pinned_window" id="close_right_info_window" style="width:23%">Close</button><button type="button" class="plp_nav_btns to_remove_from_pinned_window" id="pin_to_chrome_btn' + listing_data.place_id + '" style="width:23%"><a target="_blank" style="color:#fff">Pin</a></button><style>.plp_info_window_links a {filter: grayscale(100%)} .plp_info_window_links a:hover{background-color: #f1f1f1;filter: grayscale(0)} .single_listing_info_window table td { border-bottom:1px solid #e6e6e6; font-size: 15px; } .plp_nav_btns {line-height: 16px; margin-top: 0; margin-right: 0;background-image: none;filter: none;box-shadow: none;padding: 1px 11px;font-weight: 400;border: 1px solid rgba(0,0,0,0.13);border-radius: 0;position: relative;background-color: #6c757d;z-index: 2;color: #fff;font-size: 14px;width: 24%;margin-left: 2px;margin-bottom:4px} .plp_nav_btns:hover, #show_hide_att:hover {cursor:pointer}</style>' + innerHTML;

                                    } else {
                                          node.innerHTML = '<style>.single_listing_info_window table td {margin:0;padding:0; border-bottom:1px solid #e6e6e6 }</style><a style="float: right;padding: 10px;width: 100%;text-align:center" onclick="document.getElementById(\'place_id_fid_cid' + listing_data.place_id + '\').remove();">Close</a>' + innerHTML;
                                    }

                                    node.style.position = 'fixed';
                                    if (document.documentElement.dir === 'rtl') {
                                          node.style.left = '0px';
                                    } else {
                                          node.style.right = '0px';
                                    }

                                    if (window.innerWidth < 1450) {
                                          node.style.bottom = '0';
                                    } else {
                                          node.style.top = '20%';
                                    }
                                    node.style.width = '350px';
                                    node.style.backgroundColor = '#fff';
                                    node.style.border = '1px solid #ebebeb';
                                    node.style.color = '#4d7496';
                                    node.style.padding = '5px';
                                    node.style.borderRadius = '0';
                                    node.style.boxShadow = '-5px 5px rgb(0, 0, 0, 0.05';
                                    node.style.fontFamily = 'arial,sans-serif';
                                    node.style.zIndex = '9999';
                                    node.setAttribute("id", "place_id_fid_cid" + listing_data.place_id);
                                    node.setAttribute("class", "single_listing_info_window");
                                    document.body.appendChild(node);

                                    //EventListener for close the infowindow
                                    document.getElementById('close_right_info_window').addEventListener('click', function () {
                                          var single_listing_info_el = document.getElementsByClassName("single_listing_info_window");
                                          for (var i = 0; i < single_listing_info_el.length; i++) {
                                                single_listing_info_el[i].remove();
                                          }
                                    });

                                    //EventListener for Pin In Chrome
                                          //Save TO local Storage the last find listing
                                          document.getElementById('pin_to_chrome_btn' + listing_data.place_id).addEventListener('click', function () {
                                                setTimeout(function () {
                                                      //Rename btns class to remove after 
                                                      var to_save = document.getElementById("place_id_fid_cid" + listing_data.place_id).outerHTML.replaceAll('to_remove_from_pinned_window', 'remove_from_pinned_window');
                                                      chrome.storage.local.set({pinnedListing: to_save}, function () {
                                                            document.getElementById('pin_to_chrome_btn' + listing_data.place_id).innerHTML = "Pinned !";
                                                            var node = document.createElement("div");
                                                            node.innerHTML = 'Use CTRL+ALT+E to show / hide the listing details window ... anywhere';
                                                            node.style.position = 'fixed';
                                                            node.style.top = '0';
                                                            node.style.right = '0';
                                                            node.style.width = '495px';
                                                            node.style.backgroundColor = '#fff';
                                                            node.style.color = '#000';
                                                            node.style.padding = '15px';
                                                            node.style.boxShadow = '-5px 5px rgb(0, 0, 0, 0.05';
                                                            node.style.fontFamily = 'arial,sans-serif';
                                                            node.style.zIndex = '9999';
                                                            node.setAttribute("id", "adding_pinned_item");
                                                            document.body.appendChild(node);
                                                            setTimeout(function () {
                                                                  document.getElementById("adding_pinned_item").remove();
                                                            }, 5000);
                                                      });
                                                }, 1000);
                                          }, false);
                                    

                                    //EventListener for Save to pleper

                                    if (document.getElementById('save_to_plaper_btn' + listing_data.cid)) {
                                          document.getElementById('save_to_plaper_btn' + listing_data.cid).addEventListener('click', function () {
                                                pleper_get_user_lists(listing_data.cid, listing_data.cid, listing_data, 2);
                                          }, false);
                                    }

                                    //Close info window event
                                    if (document.getElementById('close_right_info_window')) {
                                          document.getElementById('close_right_info_window').addEventListener('click', function () {
                                                document.getElementById('place_id_fid_cid' + listing_data.place_id).remove();
                                          }, false);
                                    }

                                    //Remove after 30 seconds
                                    setTimeout(function () {
                                          if (document.getElementById("place_id_fid_cid" + listing_data.place_id)) {
                                                // document.getElementById("place_id_fid_cid" + listing_data.place_id).remove();
                                          }
                                    }, 35000);
                              }

                        }
                  }

            } catch (err) {
                  console.log('PLP Error: PLP_single_place_kg_connectExtension: ');
                  console.log(err);
            }
      });

      //New service local finder - search results
      // Local finder Single listing
      document.addEventListener('PLP_single_place_local_finder_connectExtension', function (e) {
            try {
                  //Some settings
                  if (typeof window.plp_slisting_data_value_lf === 'undefined') {
                        window.plp_hover_data_value = false;
                        window.plp_slisting_data_value_lf = false;
                        chrome.storage.sync.get(['removedContextMenu'], function (list) {
                              if (list['removedContextMenu']) {
                                    window.plp_hover_data_value = contains.call(list['removedContextMenu'], "hover_data_value");
                                    window.plp_slisting_data_value_lf = contains.call(list['removedContextMenu'], "slisting_data_value_lf");
                              }
                        });
                  }
                  var single_listing_info_el = document.getElementsByClassName("single_listing_info_window");
                  for (var i = 0; i < single_listing_info_el.length; i++) {
                        single_listing_info_el[i].remove();
                  }
                  //Destroy save to pleper window
                  if (document.getElementById('plp_user_lists')) {
                        document.getElementById('plp_user_lists').remove();
                  }

                  var xhr = new XMLHttpRequest();
                  xhr.open("POST", 'https://chrome.pleper.com/analyzer.php', true);
                  xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                  xhr.send('&response_single_place_local_finder=' + encodeURIComponent(JSON.stringify(e.detail)));
                  xhr.onreadystatechange = function () {
                        if (xhr.readyState === 4) {
                              if (window.plp_slisting_data_value_lf !== true) {
                                    var listing_data = JSON.parse(xhr.response);
                                    CID = listing_data.cid;
                                    let verified_emoji = ['<a href="https://business.google.com/create?fp=' + CID + '" target="_blank">&#10060; Not Verified</a>', '<a href="https://business.google.com/create?fp=' + CID + '" target="_blank" >&#9989; Verified</a>'];
                                    if (listing_data.name) {
                                          CID = listing_data.cid;
                                          if (listing_data.categories) {
                                                var cat_number = listing_data.categories.length;
                                          }
                                          if (cat_number > 2) {
                                                var show_cat_count = '<br>(<strong>' + cat_number + '</strong>)';
                                          } else {
                                                var show_cat_count = '';
                                          }

                                          if (listing_data.review_count == null) {
                                                listing_data.review_count = '';
                                          }
                                          if (listing_data.rating == null) {
                                                listing_data.rating = '';
                                          }
                                          if (listing_data.address == null) {
                                                listing_data.address = 'hidden';
                                          }

                                          var innerHTML = "<table style='color: rgb(77, 116, 150);overflow: hidden scroll;background-color:#fff;font-size: 15px;'><tr style='border-bottom: 2px solid #e6e6e6;border-top: 1px solid #e6e6e6;font-weight:600;text-align:center;font-size:15px'><td colspan='2'><strong>" + listing_data.name + "</strong> <small>" + verified_emoji[listing_data.verified] + "</small></td></tr>";
                                          if (listing_data.categories) {
                                                innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Categories" + show_cat_count + "</td><td>" + listing_data.categories.join(', ') + "</td></tr>";
                                          }
                                          if (window.apiKeyValue) {
                                                innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;' id='chrome_lists_row'><td style='padding:5px;font-weight:600'>Competitor Lists</td><td id='chrome_lists_row_td'></td></tr>";
                                          }
                                          //Table View
                                          innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Place ID</td><td data-pid='" + listing_data.place_id + "' title='" + listing_data.place_id + "'>" + listing_data.place_id + "</td></tr>";
                                          innerHTML += "<tr><td style='padding:5px;font-weight:600'>CID</td><td>" + CID + "</td></tr>";
                                          innerHTML += "<tr><td style='padding:5px;font-weight:600'>Business Profile ID</td><td>" + listing_data.business_profile_id + "</td></tr>";
                                          if (listing_data.address !== 'hidden' && listing_data.links.brightlocal) {
                                                innerHTML += "<tr class='plp_info_window_links' style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Address<br><a href='" + listing_data.links.brightlocal + "' target='_blank'  title='Check Google local search results from this listing location' rel='noreferrer noopener'>" + window.brightlocal_logo + "</a></td><td>" + listing_data.address + " </td></tr>";
                                          } else {
                                                innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Address</td><td>" + listing_data.address + "</td></tr>";
                                          }

                                          innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Phone</td><td>" + listing_data.phone_number + "</td></tr>";
                                          if (listing_data.website && listing_data.links.semrush) {
                                                innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;' class='plp_info_window_links'><td style='padding:5px;font-weight:600'>Website</td><td style='overflow-wrap: anywhere'>" + listing_data.website + "<br><a href='https://developers.google.com/speed/pagespeed/insights/?url=" + encodeURIComponent(listing_data.website) + "' target='_blank' style='float: left;height: 26px;width: 28px;'><img src='https://www.gstatic.com/images/icons/material/product/2x/pagespeed_64dp.png' title='PageSpeed Insights' width='24px'></a> <a href='https://www.google.com/webmasters/tools/mobile-friendly/?url=" + encodeURIComponent(listing_data.website) + "' target='_blank' title='Google Mobile Friendly Test' style='float: left;height: 26px;width: 28px;margin-left:10px'>" + window.mobile_logo + "</a> <a href='https://validator.schema.org/?url=" + encodeURIComponent(listing_data.website) + "' target='_blank' title='Structured Data Test' style='float: left;height: 26px;width: 28px;margin-left:10px'>" + window.schema_logo + "</a> <a href='https://pleper.com/tools/serpstats.php?url=" + encodeURIComponent(listing_data.website) + "' target='_blank' title='SerpStat Website Analyze' style='float: left;height: 26px;width: 28px;margin-left:10px'>" + window.serpsta_logo + "</a> <a href='" + listing_data.links.semrush + "' target='_blank' title='Semrush Website Analyze' style='float: left;height: 26px;width: 28px;margin-left:10px' rel='noreferrer noopener'>" + window.semrush_logo + "</a> <a href='" + listing_data.links.namecheap + "' target='_blank' title='Whois information' style='float: left;height: 26px;width: 28px;margin-left:14px' rel='noreferrer noopener'>" + window.namecheap_logo + "</a></td></tr>";
                                          } else {
                                                innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;' class='plp_info_window_links'><td style='padding:5px;font-weight:600'>Website</td><td>-</td></tr>";
                                          }
                                          innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Reviews</td><td>" + listing_data.review_count + "</td></tr>";
                                          innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Rating</td><td>" + listing_data.rating + "</td></tr>";
                                          if (listing_data.image_count) {
                                                innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Image Count</td><td>" + listing_data.image_count + "</td></tr>";
                                          }
                                          innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Coordinates</td><td>" + listing_data.latitude.toFixed(8) + ', ' + listing_data.longitude.toFixed(8) + "</td></tr>";
                                          innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>KG ID</td><td><a href='" + listing_data.links.google_kg + "' target='_blank'>" + listing_data.kg_id + "</a></td></tr>";
                                          if (listing_data.attribute_analyze_count) {
                                                innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;' class='to_remove_from_pinned_window'><td style='padding:5px;font-weight:600'>Attributes</td><td>" + listing_data.attribute_analyze_count + " - <a id='show_hide_att' style='font-size:13px'>Show Attributes</a></td></tr>";
                                          }
                                          if (listing_data.links) {
                                                innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;' class='plp_info_window_links'><td style='padding:5px 0;font-weight:600' colspan='2'>";
                                                innerHTML += "<a href='" + listing_data.links.google_search + "' title='Google SERP Results' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.google_search_svg + "</a>";
                                                innerHTML += "<a href='" + listing_data.links.google_maps + "' title='Google Maps Link' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.google_maps_svg + "</a>";
                                                innerHTML += "<a href='" + listing_data.links.google_prolist + "' title='Google Pro List Result' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.google_guaranteed_svg + "</a>";
                                                innerHTML += "<a href='https://search.google.com/local/writereview?placeid=" + listing_data.place_id + "' title='Google Write Review Link' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.yellow_star + "</a>";
                                                innerHTML += "<a href='" + listing_data.links.bing_search + "' title='Bing Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.bing_logo_svg + "</a>";
                                                innerHTML += "<a href='" + listing_data.links.duckduckgo + "' title='Duckduckgo Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.duckduck_logo_svg + "</a>";
                                                innerHTML += "<a href='" + listing_data.links.apple_maps + "' title='Apple Maps Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.apple_maps_svg + "</a>";
                                                innerHTML += "<a href='" + listing_data.links.yelp + "' title='Yelp Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + yelp_logo_svg + "</a>";
                                                innerHTML += "<a href='" + listing_data.links.facebook_search + "' title='Facebook Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.facebook_logo + "</a>";
//                                              innerHTML += "<a href='" + listing_data.links.openstreetmap + "' title='Facebook Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>O</a>";
                                                innerHTML += "<a href='" + listing_data.links.wikipedia_article_search + "' title='Wikipedia Near By Articles' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.wikipedia_logo + "</a>";
                                                innerHTML += "<a href='" + listing_data.links.foursquare + "' title='Foursquare Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.foursquare_logo + "</a>";
                                                if (listing_data.links.sos) {
                                                      innerHTML += "<a href='" + listing_data.links.sos + "' title='Secretary of State Business Lookup' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>SOS</a>";
                                                }


                                          }

                                          innerHTML += "</td></tr>";
                                          if (listing_data.br_flux) {
                                                innerHTML += "<tr><td colspan='2'>" + listing_data.br_flux + "</td></tr>";
                                          }
                                          innerHTML += "</table>";
                                          if (listing_data.attribute_analyze_table) {
                                                innerHTML += '<span class="to_remove_from_pinned_window">' + DOMPurify.sanitize(listing_data.attribute_analyze_table, {ALLOWED_TAGS: ['table', 'h3', 'h2', 'h1', 'ul', 'hr', 'li', 'br', 'strong', 'td', 'tr', 'td', 'button', 'a', 'div'], ALLOWED_ATTR: ['href', 'target', 'style', 'id', 'class', 'id', 'colspan']}) + '</span>';
                                                setTimeout(function () {
                                                      if (document.getElementById("show_hide_att")) {
                                                            document.getElementById('show_hide_att').addEventListener('click', function () {
                                                                  var x = document.getElementById("plp_attr_analyze");
                                                                  if (x && x.style.display === "none") {
                                                                        x.style.display = "block";
                                                                        document.getElementById('show_hide_att').innerText = "Hide Attributes";
                                                                  } else {
                                                                        x.style.display = "none";
                                                                        document.getElementById('show_hide_att').innerText = "Show Attributes";
                                                                  }
                                                            }, false);
                                                      }
                                                }, 1000);
                                          }
                                          //Destroy The Info Window
                                          if (document.getElementById("place_id_fid_cid" + listing_data.place_id)) {
                                                setTimeout(function () {
                                                      document.getElementById("place_id_fid_cid" + listing_data.place_id).remove();
                                                }, 15000);
                                          }

                                          var node = document.createElement("style");
                                          node.innerHTML = '.plp_s_info { margin-left:20px}';
                                          document.body.appendChild(node);
                                          //Remove search analyze info
                                          if (document.getElementById("category_results")) {
                                                //show_hide_category_results_again();
                                                //document.getElementById("category_results").remove();
                                                var x = document.getElementById("category_results");
                                                if (x.style.display !== "none") {
                                                      x.style.display = "none";
                                                }
                                          }
                                          //Create Info Window
                                          var node = document.createElement("div");
                                          if (listing_data.export_hash) {

                                                node.innerHTML = '<button type="button" class="plp_nav_btns to_remove_from_pinned_window" id="save_to_plaper_btn' + listing_data.cid + '"><a target="_blank" style="color:#fff">Save</a></button><button type="button" class="plp_nav_btns to_remove_from_pinned_window" style="width:23%"><a target="_blank" style="color:#fff" href="https://chrome.pleper.com/export.php?hash=' + listing_data.export_hash + '&nc=' + Date.now() + '">Export</a></button>' + '<button type="button" class="plp_nav_btns to_remove_from_pinned_window" id="close_right_info_window" style="width:23%">Close</button><button type="button" class="plp_nav_btns to_remove_from_pinned_window" id="pin_to_chrome_btn' + listing_data.place_id + '" style="width:23%"><a target="_blank" style="color:#fff">Pin</a></button><style>.plp_info_window_links a {filter: grayscale(100%)} .plp_info_window_links a:hover{background-color: #f1f1f1;filter: grayscale(0)} .single_listing_info_window table td { border-bottom:1px solid #e6e6e6; font-size: 15px; } .plp_nav_btns {line-height: 16px; margin-top: 0; margin-right: 0;background-image: none;filter: none;box-shadow: none;padding: 1px 11px;font-weight: 400;border: 1px solid rgba(0,0,0,0.13);border-radius: 0;position: relative;background-color: #6c757d;z-index: 2;color: #fff;font-size: 14px;width: 24%;margin-left: 2px;margin-bottom:4px} .plp_nav_btns:hover, #show_hide_att:hover {cursor:pointer}</style>' + innerHTML;
                                          } else {
                                                node.innerHTML = '<style>.single_listing_info_window table td { border-bottom:1px solid #e6e6e6 }</style><a style="float: right;padding: 10px;width: 100%;text-align:center" onclick="document.getElementById(\'place_id_fid_cid' + listing_data.place_id + '\').remove();">Close</a>' + innerHTML;
                                          }

                                          node.style.position = 'fixed';
                                          if (document.documentElement.dir === 'rtl') {
                                                node.style.left = '0px';
                                          } else {
                                                node.style.right = '0px';
                                          }
                                          node.style.top = '20%';
                                          node.style.width = '350px';
                                          node.style.backgroundColor = '#fff';
                                          node.style.border = '1px solid #ebebeb';
                                          node.style.color = '#4d7496';
                                          node.style.padding = '5px';
                                          node.style.borderRadius = '0';
                                          node.style.fontFamily = 'arial,sans-serif';
                                          node.style.boxShadow = '-5px 5px rgb(0, 0, 0, 0.05';
                                          node.style.zIndex = '9999';
                                          node.setAttribute("id", "place_id_fid_cid" + listing_data.place_id);
                                          node.setAttribute("class", "single_listing_info_window");
                                          document.body.appendChild(node);
                                          //EventListener for Pin In Chrome
                                                //Save TO local Storage the last find listing
                                                document.getElementById('pin_to_chrome_btn' + listing_data.place_id).addEventListener('click', function () {
                                                      setTimeout(function () {
                                                            //Rename btns class to remove after 
                                                            var to_save = document.getElementById("place_id_fid_cid" + listing_data.place_id).outerHTML.replaceAll('to_remove_from_pinned_window', 'remove_from_pinned_window');
                                                            chrome.storage.local.set({pinnedListing: to_save}, function () {
                                                                  document.getElementById('pin_to_chrome_btn' + listing_data.place_id).innerHTML = "Pinned !";
                                                                  var node = document.createElement("div");
                                                                  node.innerHTML = 'Use CTRL+ALT+E to show / hide the listing details window ... anywhere';
                                                                  node.style.position = 'fixed';
                                                                  node.style.top = '0';
                                                                  node.style.right = '0';
                                                                  node.style.width = '495px';
                                                                  node.style.backgroundColor = '#fff';
                                                                  node.style.color = '#000';
                                                                  node.style.padding = '15px';
                                                                  node.style.boxShadow = '-5px 5px rgb(0, 0, 0, 0.05';
                                                                  node.style.fontFamily = 'arial,sans-serif';
                                                                  node.style.zIndex = '9999';
                                                                  node.setAttribute("id", "adding_pinned_item");
                                                                  document.body.appendChild(node);
                                                                  setTimeout(function () {
                                                                        document.getElementById("adding_pinned_item").remove();
                                                                  }, 5000);
                                                            });
                                                      }, 1000);
                                                }, false);
                                          //Check if the listing is part of chrome list
                                          if (window.apiKeyValue) {
                                                pleper_get_list_by_cid(listing_data.cid);
                                          }

                                          //EventListener for close the infowindow
                                          document.getElementById('close_right_info_window').addEventListener('click', function () {
                                                var single_listing_info_el = document.getElementsByClassName("single_listing_info_window");
                                                for (var i = 0; i < single_listing_info_el.length; i++) {
                                                      single_listing_info_el[i].remove();
                                                }
                                          });

                                          //EventListener for Save to pleper
                                          if (document.getElementById('save_to_plaper_btn' + listing_data.cid)) {
                                                document.getElementById('save_to_plaper_btn' + listing_data.cid).addEventListener('click', function () {
                                                      pleper_get_user_lists(listing_data.cid, listing_data.cid, listing_data, 2);
                                                }, false);
                                          }


                                          //Remove after 30 seconds
                                          setTimeout(function () {
                                                if (document.getElementById("place_id_fid_cid" + listing_data.place_id)) {
                                                      // document.getElementById("place_id_fid_cid" + listing_data.place_id).remove();
                                                }
                                          }, 35000);
                                    }
                              }
                        }
                  }

            } catch (err) {
                  console.log('PLP Error: PLP_single_place_local_finder_connectExtension: ');
                  console.log(err);
            }
      });

      // Single Location Maps
      document.addEventListener('PLP_single_place_from_maps', function (e) {
            try {
                  //Show Category results again when click on "back to results" btn
                  setTimeout(function () {
                        function show_category_results_again() {

                              var x = document.getElementById("category_results");
                              if (x && x.style.display === "none") {
                                    x.style.display = "block";
                              }
                              var single_listing_info_el = document.getElementsByClassName("single_listing_info_window");
                              for (var i = 0; i < single_listing_info_el.length; i++) {
                                    single_listing_info_el[i].remove();
                              }
                        }

                        var back_to_result_btn = document.getElementsByClassName("section-back-to-list-button");
                        for (var i = 0; i < back_to_result_btn.length; i++) {
                              back_to_result_btn[i].addEventListener('click', show_category_results_again, false);
                        }
                  }, 500);

                  //Destroy save to pleper window
                  if (document.getElementById('plp_user_lists')) {
                        document.getElementById('plp_user_lists').remove();
                  }

                  //Some settings
                  if (typeof window.plp_slisting_data_value === 'undefined') {
                        window.plp_hover_data_value = false;
                        window.plp_slisting_data_value = false;
                        chrome.storage.sync.get(['removedContextMenu'], function (list) {
                              if (list['removedContextMenu']) {
                                    window.plp_hover_data_value = contains.call(list['removedContextMenu'], "hover_data_value");
                                    window.plp_slisting_data_value = contains.call(list['removedContextMenu'], "slisting_data_value");
                              }
                        });
                  }

//      	function hexToDec(hex) {
//		var num = 0n;
//		for (var x = 1; x <= hex.length; x++) {
//			var hexdigit = hex[hex.length - x];
//			num += BigInt(parseInt(hexdigit, 16)) * 16n ** (BigInt(x)-1n);
//		}
//		return num;
//	}
//      function plp_refresh () {
//            let FIDurlPart = window.location.href.indexOf("0x");
//            if (FIDurlPart) {
//                  let part = window.location.href.substring(FIDurlPart);
//                  let endPart = part.indexOf("!");
//                  var FID = part.substring(0, endPart);
//                  var CID_hexed = FID.split(":0x");
//                  CID = hexToDec(CID_hexed[1]).toString();
//                  var xhr = new XMLHttpRequest();
//                  xhr.open("GET", "https://" + window.location.host + "/maps/?cid=" + CID);
//                  xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
//                  xhr.send();
//                  xhr.onreadystatechange = function () {
//                        if (xhr.readyState === 4) {
//                              var toSend = encodeURIComponent(xhr.response);
//                              setTimeout(function () {
//                                    document.dispatchEvent(new CustomEvent('PLP_single_place_local_finder_connectExtension', {
//                                          detail: toSend
//                                    }));
//                              }, 0);
//                        }
//                  }
//
//            }
//      }
//            setTimeout(function () {
//                  if (document.getElementById("plp_refresh")) {
//                        document.getElementById("plp_refresh").addEventListener("click", plp_refresh, false);
//                  }
//            }, 15000);

                  var xhr = new XMLHttpRequest();
                  xhr.open("POST", 'https://chrome.pleper.com/analyzer.php', true);
                  xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                  xhr.send('&response=' + encodeURIComponent(JSON.stringify(e.detail)));
                  xhr.onreadystatechange = function () {
                        if (xhr.readyState === 4) {
                              if (!window.plp_slisting_data_value) {
                                    var listing_data = JSON.parse(xhr.response);
                                    CID = listing_data.cid;
                                    let verified_emoji = ['<a href="https://business.google.com/create?fp=' + CID + '" target="_blank">&#10060; Not Verified</a>', '<a href="https://business.google.com/create?fp=' + CID + '" target="_blank" >&#9989; Verified</a>'];
                                    if (listing_data.name) {
                                          CID = listing_data.cid;
                                          if (listing_data.categories) {
                                                var cat_number = listing_data.categories.length;
                                          }
                                          if (cat_number > 2) {
                                                var show_cat_count = '<br>(<strong>' + cat_number + '</strong>)';
                                          } else {
                                                var show_cat_count = '';
                                          }

                                          var current_url = window.location.href;
                                          if (current_url.indexOf('cid=') !== -1 || (decodeURIComponent(window.location.href).indexOf(listing_data.name_for_check) !== -1)) {

                                                var single_listing_info_el = document.getElementsByClassName("single_listing_info_window");
                                                for (var i = 0; i < single_listing_info_el.length; i++) {
                                                      single_listing_info_el[i].remove();
                                                }

                                                //Remove the old window with cat analyze
                                                if (document.getElementById("category_results")) {
                                                      document.getElementById("category_results").remove();
                                                }
                                                if (listing_data.review_count == null) {
                                                      listing_data.review_count = '';
                                                }
                                                if (listing_data.rating == null) {
                                                      listing_data.rating = '';
                                                }
                                                if (listing_data.address == null) {
                                                      listing_data.address = 'hidden';
                                                }

                                                var innerHTML = "<table style='color: rgb(77, 116, 150);overflow: hidden scroll;background-color:#fff;font-size: 15px;'><tr style='border-bottom: 2px solid #e6e6e6;border-top: 1px solid #e6e6e6;font-weight:600;text-align:center;font-size:15px'><td colspan='2'><strong>" + listing_data.name + "</strong> <small>" + verified_emoji[listing_data.verified] + "</small></td></tr>";
                                                if (listing_data.categories) {
                                                      innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Categories" + show_cat_count + "</td><td>" + listing_data.categories.join(', ') + "</td></tr>";
                                                }
                                                if (window.apiKeyValue) {
                                                      innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;' id='chrome_lists_row'><td style='padding:5px;font-weight:600'>Competitor Lists</td><td id='chrome_lists_row_td'></td></tr>";
                                                }
                                                //Table View
                                                innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Place ID</td><td data-pid='" + listing_data.place_id + "' title='" + listing_data.place_id + "'>" + listing_data.place_id + "</td></tr>";
                                                innerHTML += "<tr><td style='padding:5px;font-weight:600'>CID</td><td>" + CID + "</td></tr>";
                                                innerHTML += "<tr><td style='padding:5px;font-weight:600'>Business Profile ID</td><td>" + listing_data.business_profile_id + "</td></tr>";
                                                if (listing_data.address !== 'hidden' && listing_data.links.brightlocal) {
                                                      innerHTML += "<tr class='plp_info_window_links' style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Address<br><a href='" + listing_data.links.brightlocal + "' target='_blank'  title='Check Google local search results from this listing location' rel='noreferrer noopener'>" + window.brightlocal_logo + "</a></td><td>" + listing_data.address + " </td></tr>";
                                                } else {
                                                      innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Address</td><td>" + listing_data.address + "</td></tr>";
                                                }

                                                innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Phone</td><td>" + listing_data.phone_number + "</td></tr>";
                                                if (listing_data.website && listing_data.links.semrush) {
                                                      innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;' class='plp_info_window_links'><td style='padding:5px;font-weight:600'>Website</td><td style='overflow-wrap: anywhere'>" + listing_data.website + "<br><a href='https://developers.google.com/speed/pagespeed/insights/?url=" + encodeURIComponent(listing_data.website) + "' target='_blank' style='float: left;height: 26px;width: 28px;'><img src='https://www.gstatic.com/images/icons/material/product/2x/pagespeed_64dp.png' title='PageSpeed Insights' width='24px'></a> <a href='https://www.google.com/webmasters/tools/mobile-friendly/?url=" + encodeURIComponent(listing_data.website) + "' target='_blank' title='Google Mobile Friendly Test' style='float: left;height: 26px;width: 28px;margin-left:10px'>" + window.mobile_logo + "</a> <a href='https://validator.schema.org/?url=" + encodeURIComponent(listing_data.website) + "' target='_blank' title='Structured Data Test' style='float: left;height: 26px;width: 28px;margin-left:10px'>" + window.schema_logo + "</a> <a href='https://pleper.com/tools/serpstats.php?url=" + encodeURIComponent(listing_data.website) + "' target='_blank' title='SerpStat Website Analyze' style='float: left;height: 26px;width: 28px;margin-left:10px'>" + window.serpsta_logo + "</a> <a href='" + listing_data.links.semrush + "' target='_blank' title='Semrush Website Analyze' style='float: left;height: 26px;width: 28px;margin-left:10px' rel='noreferrer noopener'>" + window.semrush_logo + "</a> <a href='" + listing_data.links.namecheap + "' target='_blank' title='Whois information' style='float: left;height: 26px;width: 28px;margin-left:14px' rel='noreferrer noopener'>" + window.namecheap_logo + "</a></td></tr>";
                                                } else {
                                                      innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;' class='plp_info_window_links'><td style='padding:5px;font-weight:600'>Website</td><td>-</td></tr>";
                                                }
                                                innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Reviews</td><td>" + listing_data.review_count + "</td></tr>";
                                                innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Rating</td><td>" + listing_data.rating + "</td></tr>";
                                                if (listing_data.image_count) {
                                                      innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Image Count</td><td>" + listing_data.image_count + "</td></tr>";
                                                }
                                                innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>Coordinates</td><td>" + listing_data.latitude.toFixed(8) + ', ' + listing_data.longitude.toFixed(8) + "</td></tr>";
                                                innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;'><td style='padding:5px;font-weight:600'>KG ID</td><td><a href='" + listing_data.links.google_kg + "' target='_blank'>" + listing_data.kg_id + "</a></td></tr>";
                                                if (listing_data.attribute_analyze_count) {
                                                      innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;' class='to_remove_from_pinned_window'><td style='padding:5px;font-weight:600'>Attributes</td><td>" + listing_data.attribute_analyze_count + " - <a id='show_hide_att' style='font-size:13px'>Show Attributes</a></td></tr>";
                                                }
                                                if (listing_data.links) {
                                                      innerHTML += "<tr style='border-bottom: 1px solid #e6e6e6;' class='plp_info_window_links'><td style='padding:5px 0;font-weight:600' colspan='2'>";
                                                      innerHTML += "<a href='" + listing_data.links.google_search + "' title='Google SERP Results' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.google_search_svg + "</a>";
                                                      innerHTML += "<a href='" + listing_data.links.google_maps + "' title='Google Maps Link' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.google_maps_svg + "</a>";
                                                      innerHTML += "<a href='" + listing_data.links.google_prolist + "' title='Google Pro List Result' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.google_guaranteed_svg + "</a>";
                                                      innerHTML += "<a href='https://search.google.com/local/writereview?placeid=" + listing_data.place_id + "' title='Google Write Review Link' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.yellow_star + "</a>";
                                                      innerHTML += "<a href='" + listing_data.links.bing_search + "' title='Bing Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.bing_logo_svg + "</a>";
                                                      innerHTML += "<a href='" + listing_data.links.duckduckgo + "' title='Duckduckgo Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.duckduck_logo_svg + "</a>";
                                                      innerHTML += "<a href='" + listing_data.links.apple_maps + "' title='Apple Maps Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.apple_maps_svg + "</a>";
                                                      innerHTML += "<a href='" + listing_data.links.yelp + "' title='Yelp Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + yelp_logo_svg + "</a>";
                                                      innerHTML += "<a href='" + listing_data.links.facebook_search + "' title='Facebook Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.facebook_logo + "</a>";
//                                              innerHTML += "<a href='" + listing_data.links.openstreetmap + "' title='Facebook Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>O</a>";
                                                      innerHTML += "<a href='" + listing_data.links.wikipedia_article_search + "' title='Wikipedia Near By Articles' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.wikipedia_logo + "</a>";
                                                      innerHTML += "<a href='" + listing_data.links.foursquare + "' title='Foursquare Search' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>" + window.foursquare_logo + "</a>";
                                                      if (listing_data.links.sos) {
                                                            innerHTML += "<a href='" + listing_data.links.sos + "' title='Secretary of State Business Lookup' target='_blank' style='float: left;height: 26px;width: 26px;margin-left:5px'>SOS</a>";
                                                      }
                                                }
                                                innerHTML += "</td></tr>";
                                                if (listing_data.br_flux) {
                                                      innerHTML += "<tr><td colspan='2'>" + listing_data.br_flux + "</td></tr>";
                                                }

                                                innerHTML += "</table>";
                                                if (listing_data.attribute_analyze_table) {
                                                      innerHTML += '<span class="to_remove_from_pinned_window">' + DOMPurify.sanitize(listing_data.attribute_analyze_table, {ALLOWED_TAGS: ['table', 'h3', 'h2', 'h1', 'ul', 'hr', 'li', 'br', 'strong', 'td', 'tr', 'td', 'button', 'a', 'div'], ALLOWED_ATTR: ['href', 'target', 'style', 'id', 'class', 'id', 'colspan']}) + '</span>';
                                                      setTimeout(function () {
                                                            if (document.getElementById("show_hide_att")) {
                                                                  document.getElementById('show_hide_att').addEventListener('click', function () {
                                                                        var x = document.getElementById("plp_attr_analyze");
                                                                        if (x && x.style.display === "none") {
                                                                              x.style.display = "block";
                                                                              document.getElementById('show_hide_att').innerText = "Hide Attributes";
                                                                        } else {
                                                                              x.style.display = "none";
                                                                              document.getElementById('show_hide_att').innerText = "Show Attributes";
                                                                        }
                                                                  }, false);
                                                            }
                                                      }, 1000);
                                                }
                                                //Destroy The Info Window
                                                if (document.getElementById("place_id_fid_cid" + listing_data.place_id)) {
                                                      setTimeout(function () {
                                                            document.getElementById("place_id_fid_cid" + listing_data.place_id).remove();
                                                      }, 15000);
                                                }

                                                var node = document.createElement("style");
                                                node.innerHTML = '.plp_s_info { margin-left:20px}';
                                                document.body.appendChild(node);
                                                //Remove search analyze info
                                                if (document.getElementById("category_results")) {
                                                      //show_hide_category_results_again();
                                                      //document.getElementById("category_results").remove();
                                                      var x = document.getElementById("category_results");
                                                      if (x.style.display !== "none") {
                                                            x.style.display = "none";
                                                      }
                                                }
                                                //Create Info Window
                                                var node = document.createElement("div");
                                                //Purify the innerHTML for additional safety
                                                if (listing_data.export_hash) {
                                                      //If user has API KEY
                                                      if (1 === 1) {
                                                            node.innerHTML = '<button type="button" class="plp_nav_btns to_remove_from_pinned_window" id="save_to_plaper_btn' + listing_data.cid + '"><a target="_blank" style="color:#fff">Save</a></button><button type="button" class="plp_nav_btns to_remove_from_pinned_window" style="width:23%"><a target="_blank" style="color:#fff" href="https://chrome.pleper.com/export.php?hash=' + listing_data.export_hash + '&nc=' + Date.now() + '">Export</a></button>' + '<button type="button" class="plp_nav_btns to_remove_from_pinned_window" id="close_right_info_window" style="width:23%">Close</button><button type="button" class="plp_nav_btns to_remove_from_pinned_window" id="pin_to_chrome_btn' + listing_data.place_id + '" style="width:23%"><a target="_blank" style="color:#fff">Pin</a></button><style>.plp_info_window_links a {filter: grayscale(100%)} .plp_info_window_links a:hover{background-color: #f1f1f1;filter: grayscale(0)} .single_listing_info_window table td { border-bottom:1px solid #e6e6e6; font-size: 15px; } .plp_nav_btns {line-height: 16px; margin-top: 0; margin-right: 0;background-image: none;filter: none;box-shadow: none;padding: 1px 11px;font-weight: 400;border: 1px solid rgba(0,0,0,0.13);border-radius: 0;position: relative;background-color: #6c757d;z-index: 2;color: #fff;font-size: 14px;width: 24%;margin-left: 2px;margin-bottom:4px} .plp_nav_btns:hover, #show_hide_att:hover {cursor:pointer}</style>' + innerHTML;
                                                      } else {
                                                            node.innerHTML = '<button type="button" class="plp_nav_btns to_remove_from_pinned_window" style="width:37%"><a target="_blank" style="color:#fff" href="https://chrome.pleper.com/export.php?hash=' + listing_data.export_hash + '&nc=' + Date.now() + '">Export</a></button>' + '<button type="button" class="plp_nav_btns to_remove_from_pinned_window" id="close_right_info_window" style="width:37%">Close</button><button type="button" class="plp_nav_btns to_remove_from_pinned_window" id="pin_to_chrome_btn' + listing_data.place_id + '" style="width:23%"><a target="_blank" style="color:#fff">Pin</a></button><style>.plp_info_window_links a {filter: grayscale(100%)} .plp_info_window_links a:hover{background-color: #f1f1f1;filter: grayscale(0)} .single_listing_info_window table td { border-bottom:1px solid #e6e6e6; font-size: 15px; } .plp_nav_btns {line-height: 16px; margin-top: 0; margin-right: 0;background-image: none;filter: none;box-shadow: none;padding: 1px 11px;font-weight: 400;border: 1px solid rgba(0,0,0,0.13);border-radius: 0;position: relative;background-color: #6c757d;z-index: 2;color: #fff;font-size: 14px;width: 40%;margin-left: 2px;margin-bottom:4px} .plp_nav_btns:hover, #show_hide_att:hover {cursor:pointer}</style>' + innerHTML;
                                                      }
                                                } else {
                                                      node.innerHTML = '<style>.single_listing_info_window table td { border-bottom:1px solid #e6e6e6 }</style><a style="float: right;padding: 10px;width: 100%;text-align:center" onclick="document.getElementById(\'place_id_fid_cid' + listing_data.place_id + '\').remove();">Close</a>' + innerHTML;
                                                }


                                                node.style.position = 'fixed';
                                                if (document.documentElement.dir === 'rtl') {
                                                      node.style.left = '0px';
                                                } else {
                                                      node.style.right = '0px';
                                                }
                                                node.style.top = '70px';
                                                node.style.width = '350px';
                                                node.style.backgroundColor = '#fff';
                                                node.style.border = '1px solid #ebebeb';
                                                node.style.color = '#4d7496';
                                                node.style.padding = '5px';
                                                node.style.boxShadow = '-5px 5px rgb(0, 0, 0, 0.05';
                                                node.style.fontFamily = 'arial,sans-serif';
                                                node.setAttribute("id", "place_id_fid_cid" + listing_data.place_id);
                                                node.setAttribute("class", "single_listing_info_window");
                                                node.style.zIndex = '9999';
                                                document.body.appendChild(node);
                                                //Check if the listing is part of chrome list
                                                if (window.apiKeyValue) {
                                                      pleper_get_list_by_cid(listing_data.cid);
                                                }
                                                //EventListener for close the infowindow
                                                document.getElementById('close_right_info_window').addEventListener('click', function () {
                                                      var single_listing_info_el = document.getElementsByClassName("single_listing_info_window");
                                                      for (var i = 0; i < single_listing_info_el.length; i++) {
                                                            single_listing_info_el[i].remove();
                                                      }
                                                });

                                                //EventListener for Pin In Chrome
                                                //Save TO local Storage the last find listing
                                                document.getElementById('pin_to_chrome_btn' + listing_data.place_id).addEventListener('click', function () {
                                                      setTimeout(function () {
                                                            //Rename btns class to remove after 
                                                            var to_save = document.getElementById("place_id_fid_cid" + listing_data.place_id).outerHTML.replaceAll('to_remove_from_pinned_window', 'remove_from_pinned_window');
                                                            chrome.storage.local.set({pinnedListing: to_save}, function () {
                                                                  document.getElementById('pin_to_chrome_btn' + listing_data.place_id).innerHTML = "Pinned !";
                                                                  var node = document.createElement("div");
                                                                  node.innerHTML = 'Use CTRL+ALT+E to show / hide the listing details window ... anywhere';
                                                                  node.style.position = 'fixed';
                                                                  node.style.top = '0';
                                                                  node.style.right = '0';
                                                                  node.style.width = '495px';
                                                                  node.style.backgroundColor = '#fff';
                                                                  node.style.color = '#000';
                                                                  node.style.padding = '15px';
                                                                  node.style.boxShadow = '-5px 5px rgb(0, 0, 0, 0.05';
                                                                  node.style.fontFamily = 'arial,sans-serif';
                                                                  node.style.zIndex = '9999';
                                                                  node.setAttribute("id", "adding_pinned_item");
                                                                  document.body.appendChild(node);
                                                                  setTimeout(function () {
                                                                        document.getElementById("adding_pinned_item").remove();
                                                                  }, 5000);
                                                            });
                                                      }, 1000);
                                                }, false);


                                                //EventListener for Save to pleper
                                                if (1 === 1) {
                                                      if (document.getElementById('save_to_plaper_btn' + listing_data.cid)) {
                                                            document.getElementById('save_to_plaper_btn' + listing_data.cid).addEventListener('click', function () {
                                                                  pleper_get_user_lists(listing_data.cid, listing_data.cid, listing_data, 3);
                                                            }, false);
                                                      }
                                                }
                                          }
                                    }
                              }
                        }
                  }
//            });
            } catch (err) {
                  console.log('PLP Error: PLP_single_place_from_maps: ');
                  console.log(err);
            }
      });

      // Maps search results
      document.addEventListener('PLP_maps_search_results', function (e) {
            try {
                  if (typeof window.plp_search_result_analyze === 'undefined') {
                        //Some settings
                        window.plp_search_result_analyze = false;
                        chrome.storage.sync.get(['removedContextMenu'], function (list) {
                              if (list['removedContextMenu']) {
                                    window.plp_search_result_analyze = contains.call(list['removedContextMenu'], "search_result_analyze");
                              }
                        });
                  }
                  var xhr = new XMLHttpRequest();
                  xhr.open("POST", 'https://chrome.pleper.com/analyzer.php', true);
                  xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                  xhr.send('search_response=' + e.detail);
                  xhr.onreadystatechange = function () {

                        //Destroy previus verified info
                        let plp_verified_data = document.getElementsByClassName("plp_verified_class");
                        for (let i = 0; i < plp_verified_data.length + 1; i++) {
                              if (plp_verified_data.item(i)) {
                                    plp_verified_data.item(i).remove();
                              }
                        }
                        for (let i = 0; i < plp_verified_data.length + 1; i++) {
                              if (plp_verified_data.item(i)) {
                                    plp_verified_data.item(i).remove();
                              }
                        }
                        //Destroy save to pleper window
                        if (document.getElementById('plp_user_lists')) {
                              document.getElementById('plp_user_lists').remove();
                        }

                        let results_container_to_scroll = document.querySelectorAll('[class*="section-layout-flex-vertical"]');
                        if (xhr.readyState === 4) {
                              if (xhr.response) {
                                    if (1 == 1) {  //if (!window.plp_search_result_analyze) {
                                          var search_data = JSON.parse(xhr.response);
                                          //When the single place is part of search results ... identify whet is is At This Place : ( 
                                          var current_url = decodeURIComponent(window.location.href);
                                          let is_single_place = current_url.indexOf("/maps/place/");
                                          if (is_single_place !== -1 && typeof search_data[0]['at_this_place_search'] === 'undefined') {
                                                return;
                                          }

                                          //Only the search result analyze div on the right
                                          setTimeout(function () {
                                                let total_result_returned = search_data.length;
                                                var cats_total = {'Total Categories': 0};
                                                for (let i = 0; i < total_result_returned; i++) {
                                                      plp_index = i + 1;
                                                      if (typeof search_data[plp_index] !== 'undefined' && typeof search_data[plp_index]['name'] !== 'undefined') {
                                                            //Category Analyze
                                                            if (search_data[plp_index]['categories']) {
                                                                  search_data[plp_index]['categories'].forEach(function (singleCat) {
                                                                        if (!cats_total[singleCat]) {
                                                                              cats_total[singleCat] = 0;
                                                                        }
                                                                        cats_total['Total Categories']++;
                                                                        cats_total[singleCat]++;
                                                                  });
                                                            }
                                                      }
                                                }


                                                //The info window with categories and reviews analyze
                                                if (typeof cats_total === 'object' && cats_total !== null && cats_total['Total Categories'] > 1) {
                                                      //Remove the old window with cat analyze
                                                      if (document.getElementById("category_results")) {
                                                            document.getElementById("category_results").remove();
                                                      }

                                                      if (document.documentElement.dir === 'rtl') {
                                                            var innerHTML = '<div id="plp_btns" style="position:fixed;top:70px;left:0px;width:345px;"><button type="button" class="category_analyze_show_hide" id="my_js_sucks_categories">Categories</button>';
                                                      } else {
                                                            var innerHTML = '<div id="plp_btns" style="position:fixed;top:70px;right:0px;width:345px;"><button type="button" class="category_analyze_show_hide" id="my_js_sucks_categories">Categories</button>';
                                                      }

                                                      innerHTML += '<button type="button" class="reviews_analyze_show_hide" id="my_js_sucks_reviews">Reviews</button>';
                                                      innerHTML += '<button type="button" class="attributes_analyze_show_hide" id="my_js_sucks_attributes">Attributes</button>';
                                                      innerHTML += '<button type="button" class="next_cool_thing_show_hide" id="my_js_sucks_next">Business Hours</button></div>';
                                                      //Purify the innerHTML for additional safety
                                                      if (search_data[0]['export_hash']) {
                                                            innerHTML += '<button type="button" class="plp_nav_btns" id="save_to_plaper_btn' + search_data[0]['cids'] + '" style="padding: 1px 6px;width:36%"><a target="_blank" style="color:#fff">Save</a></button>';
                                                            innerHTML += '</div>';
                                                            innerHTML += '<button type="button" class="plp_nav_btns" id="set_data_to_results" style="padding: 1px 6px;width:36%">Set Data</button>';
                                                            innerHTML += '<button type="button" class="plp_nav_btns" id="close_right_info_window" onclick="document.getElementById(\'category_results\').remove();" style="padding: 1px 6px;width:24%">Close</button>';

                                                      } else {
                                                            innerHTML += '<button type="button" style="width:49%" class="plp_nav_btns" id="set_data_to_results">Set Data</button>';
                                                            innerHTML += '<button type="button" style="width:49%" class="plp_nav_btns" onclick="document.getElementById(\'category_results\').remove();" id="my_js_sucks_reviews">Close</button>';
                                                      }

                                                      innerHTML += '<div id="plp_table_analyzes">';
                                                      if (search_data[0].br_flux) {
                                                            innerHTML += search_data[0].br_flux;
                                                      }

                                                      //Category analyze
                                                      if (typeof search_data[0] !== 'undefined' && typeof search_data[0]['category_analyze_table'] !== 'undefined') {
                                                            //innerHTML += search_data[0]['additional_info_table'];
                                                            innerHTML += DOMPurify.sanitize(search_data[0]['category_analyze_table'], {ALLOWED_TAGS: ['a', 'target', 'table', 'br', 'strong', 'td', 'tr', 'td'], ALLOWED_ATTR: ['a', 'href', 'target', 'style', 'class', 'id', 'colspan', 'rel']});
                                                      }

                                                      //Review analyze
                                                      if (typeof search_data[0] !== 'undefined' && typeof search_data[0]['review_analyze_table'] !== 'undefined') {
                                                            innerHTML += '<br>' + DOMPurify.sanitize(search_data[0]['review_analyze_table'], {ALLOWED_TAGS: ['table', 'br', 'strong', 'td', 'tr', 'td'], ALLOWED_ATTR: ['style', 'class', 'id', 'colspan', 'rel']});
                                                      }

                                                      //Atributes analyze
                                                      if (typeof search_data[0] !== 'undefined' && typeof search_data[0]['attribute_analyze_table'] !== 'undefined') {
                                                            innerHTML += '<br>' + DOMPurify.sanitize(search_data[0]['attribute_analyze_table'], {ALLOWED_TAGS: ['table', 'br', 'strong', 'td', 'tr', 'td'], ALLOWED_ATTR: ['style', 'class', 'id', 'colspan', 'rel']});
                                                      }

                                                      //Business hours analyze
                                                      if (typeof search_data[0] !== 'undefined' && typeof search_data[0]['business_hours_table'] !== 'undefined') {
                                                            innerHTML += '<br>' + DOMPurify.sanitize(search_data[0]['business_hours_table'], {ALLOWED_TAGS: ['table', 'br', 'strong', 'td', 'tr', 'td'], ALLOWED_ATTR: ['style', 'class', 'id', 'colspan']});
                                                      }

                                                      innerHTML += '<h3 class="next_cool_thing" style="text-align:center;width:90%;">Suggestion at dev@pleper.com : )</h3>';
                                                      //?
                                                      var calcedHeight = 15 * 3.2;
                                                      calcedHeight += 20;
                                                      //Create Info Window
                                                      var node = document.createElement("div");
                                                      node.innerHTML = DOMPurify.sanitize(innerHTML, {ALLOWED_TAGS: ['table', 'h3', 'br', 'strong', 'td', 'tr', 'td', 'button', 'a', 'div'], ALLOWED_ATTR: ['href', 'target', 'style', 'id', 'class', 'id', 'colspan', 'onclick']});
                                                      node.style.position = 'fixed';
                                                      if (document.documentElement.dir === 'rtl') {
                                                            node.style.left = '0px';
                                                      } else {
                                                            node.style.right = '0px';
                                                      }
                                                      node.style.top = '138px';
                                                      if (calcedHeight < 15) {
                                                            calcedHeight = 15;
                                                      }
                                                      if (calcedHeight > 100) {
                                                            calcedHeight = 78;
                                                            node.style.overflow = 'auto';
                                                      }
                                                      node.style.height = calcedHeight + '%';
                                                      node.style.width = '335px';
                                                      node.style.backgroundColor = '#fff';
                                                      node.style.color = '#4d7496';
                                                      node.style.padding = '5px';
                                                      node.style.overflow = 'scroll';
                                                      node.style.overflowX = 'hidden';
                                                      node.style.boxShadow = '-5px 5px rgb(0, 0, 0, 0.05';
                                                      node.style.fontFamily = 'arial,sans-serif';
                                                      node.style.zIndex = '9999';
                                                      node.setAttribute("id", "category_results");
                                                      node.setAttribute("class", "scrollable-x");
                                                      document.body.appendChild(node);
                                                      //Remove single listing info windows
                                                      var single_listing_info_el = document.getElementsByClassName("single_listing_info_window");
                                                      for (var i = 0; i < single_listing_info_el.length; i++) {
                                                            single_listing_info_el[i].remove();
                                                      }

                                                      //EventListener for show user lists and Save to pleper
                                                      document.getElementById('save_to_plaper_btn' + search_data[0]['cids']).addEventListener('click', function () {
                                                            pleper_get_user_lists(search_data[0]['cids'], search_data[0]['cids'], search_data);
                                                      }, false);

                                                      setTimeout(function () {
                                                            function close_category_results() {
                                                                  document.getElementById('category_results').remove();
                                                            }
                                                            if (document.getElementById("set_data_to_results")) {
                                                                  document.getElementById("set_data_to_results").addEventListener("click", set_data_to_results, false);
                                                            }
                                                            if (document.getElementById("close_right_info_window")) {
                                                                  document.getElementById("close_right_info_window").addEventListener("click", close_category_results, false);
                                                            }
                                                      }, 2000);
                                                      var node = document.createElement("style");
                                                      node.innerHTML = '.red_name{color:#a20000; fotn-weight:600} .category_analyze_show_hide,.next_cool_thing_show_hide, .reviews_analyze_show_hide, .attributes_analyze_show_hide {background-image: none;filter: none;box-shadow: none;padding: 7px 13px;font-weight: 400;border: 1px solid rgba(0,0,0,0.13);border-radius: 0;position: relative;background-color: #3968c6;z-index: 2;color:#fff;width:50%;}.category_analyze_table, .review_analyze_table, .attributes_analyze_table, .next_cool_thing, .business_hours_analyze_table {display:block} .hide_table {display:none !important} .plp_nav_btns {line-height: 16px; margin-top: 0; margin-right: 0;background-image: none;filter: none;box-shadow: none;padding: 1px 11px;font-weight: 400;border: 1px solid rgba(0,0,0,0.13);border-radius: 0;position: relative;background-color: #6c757d;z-index: 2;color: #fff;font-size: 14px;width: 32%;margin-left: 2px;} .plp_nav_btns:hover {cursor:pointer}';
                                                      document.body.appendChild(node);
                                                      document.querySelector('.category_analyze_show_hide').addEventListener('click', function (e) {
                                                            document.querySelector("#plp_cat_analyze_table").scrollIntoView({behavior: "smooth", block: "start", inline: "nearest"});
                                                      });
                                                      document.querySelector('.reviews_analyze_show_hide').addEventListener('click', function (e) {
                                                            document.querySelector("#plp_review_analyze_table").scrollIntoView({behavior: "smooth", block: "start", inline: "nearest"});
                                                      });
                                                      document.querySelector('.attributes_analyze_show_hide').addEventListener('click', function (e) {
                                                            document.querySelector("#plp_attributes_analyze_table").scrollIntoView({behavior: "smooth", block: "start", inline: "nearest"});
                                                      });
                                                      document.querySelector('.next_cool_thing_show_hide').addEventListener('click', function (e) {
                                                            document.querySelector("#plp_business_hours_analyze_table").scrollIntoView({behavior: "smooth", block: "start", inline: "nearest"});
                                                      });
                                                }


                                                function set_data_to_results() {
                                                      //Destroy previus verified info
                                                      let plp_verified_data = document.getElementsByClassName("plp_verified_class");
                                                      for (let i = 0; i < plp_verified_data.length; i++) {
                                                            if (plp_verified_data.item(i)) {
                                                                  plp_verified_data.item(i).remove();
                                                            }
                                                      }
                                                      //Destroy previus verified info
                                                      plp_verified_data = document.getElementsByClassName("plp_verified_class");
                                                      for (let i = 0; i < plp_verified_data.length; i++) {
                                                            if (plp_verified_data.item(i)) {
                                                                  plp_verified_data.item(i).remove();
                                                            }
                                                      }
                                                      setTimeout(function () {
                                                            var node = document.createElement("div");
                                                            node.innerHTML = '<div>Adding Categories/Verified status to the results, please wait ...</div>';
                                                            node.style.position = 'fixed';
                                                            node.style.top = '8px';
                                                            node.style.left = '463px';
                                                            node.style.height = '38px';
                                                            node.style.width = '495px';
                                                            node.style.backgroundColor = '#fff';
                                                            node.style.color = '#000';
                                                            node.style.padding = '6px';
                                                            node.style.boxShadow = '-5px 5px rgb(0, 0, 0, 0.05';
                                                            node.style.fontFamily = 'arial,sans-serif';
                                                            node.style.zIndex = '9999';
                                                            node.setAttribute("id", "adding_categories_to_results");
                                                            node.setAttribute("class", "scrollable-x");
                                                            document.body.appendChild(node);
                                                            results_container_name = document.querySelectorAll('[class*="TFQHme"]');
                                                            results_container_name_length = results_container_name.length - 2;
                                                            results_container_name[results_container_name_length].scrollIntoView({block: "start"});
                                                            //console.log('scroll 1');

                                                            setTimeout(function () {
                                                                  results_container_name = document.querySelectorAll('[class*="TFQHme"]');
                                                                  results_container_name_length = results_container_name.length - 2;
                                                                  results_container_name[results_container_name_length].scrollIntoView({block: "start"});
                                                                  //console.log('scroll 2');

                                                                  setTimeout(function () {
                                                                        //Destroy previus verified info
                                                                        let plp_verified_data = document.getElementsByClassName("plp_verified_class");
                                                                        for (let i = 0; i < plp_verified_data.length + 1; i++) {
                                                                              if (plp_verified_data.item(i)) {
                                                                                    plp_verified_data.item(i).remove();
                                                                              }
                                                                        }

                                                                        //Back to top
                                                                        document.querySelectorAll('[class*="fontTitleLarge "]')[0].scrollIntoView({block: "start"});

                                                                        let verified_emoji = ['&#10060; ', '&#9989; '];
                                                                        let container_key = 0;
                                                                        let name_container_key = 0;
                                                                        let results_container_lenght = document.querySelectorAll('[class*="Nv2PK"]').length;
                                                                        if (results_container_lenght > 40) {
                                                                              container_key = results_container_lenght - 40;
                                                                        }
                                                                        if (results_container_lenght > 20) {
                                                                              var to_start = results_container_lenght - 20;
                                                                        } else {
                                                                              var to_start = 0;
                                                                        }

                                                                        /** Remove info window for adding details to the result */
                                                                        setTimeout(function () {
                                                                              if (document.getElementById("adding_categories_to_results")) {
                                                                                    document.getElementById("adding_categories_to_results").remove();
                                                                              }
                                                                        }, 3000);
                                                                        var plp_index = 0;

                                                                        for (let i = to_start; i < results_container_lenght; i++) {
                                                                              plp_index++;

                                                                              if (typeof search_data[plp_index] !== 'undefined' && typeof search_data[plp_index]['name'] !== 'undefined') {
                                                                                    let el = document.querySelectorAll('[class*="Nv2PK"]')[i];
                                                                                    let peak_wait_up = '';
                                                                                    if (!window.plp_search_result_peak_wait) {
                                                                                          if (typeof search_data[plp_index]['peak_wait_up'] !== 'undefined') {
                                                                                                let peak_wait_up = search_data[plp_index]['peak_wait_up'] + '<br>';
                                                                                          }
                                                                                    }
                                                                                    if (!window.plp_search_data_value) {
                                                                                          let search_cid_info = '<strong class="search_cid_info">CID:</strong> ' + search_data[plp_index]['cid'] + '<br>';
                                                                                          let search_cat_info = verified_emoji[search_data[plp_index]['verified']] + '<strong class="search_cat_info">Categories:</strong> ' + search_data[plp_index]['categories'] + '<br>';
                                                                                          let search_distance = 'Distance: ' + search_data[plp_index]['distance'] + ' m<br>';
                                                                                          let catInfoMaps = document.createElement("div");
                                                                                          catInfoMaps.innerHTML += '<div class="plp_verified_class" style="color:#4d7496;margin-left:22px"><small>' + search_cat_info + search_distance + peak_wait_up + '</small></div>';
                                                                                          el.append(catInfoMaps);
                                                                                    }
                                                                              }
                                                                              container_key++;
                                                                        }
                                                                  }, 700);
                                                            }, 700);
                                                      }, 700);
                                                }
                                          }, 50);
                                          /** FF duplicate the request? */
                                          setTimeout(function () {
                                                let plp_verified_data = document.getElementsByClassName("plp_verified_class");
                                                if (plp_verified_data.length > 20) {
                                                      for (let i = 0; i < plp_verified_data.length + 1; i++) {
                                                            if (i % 2 == 0 && plp_verified_data.item(i)) {
                                                                  plp_verified_data.item(i).remove();
                                                            }
                                                      }
                                                }
                                          }, 5700);
                                    }
                              }
                        }
                  }
            } catch (err) {
                  console.log('PLP Error: PLP_maps_search_results: ');
                  console.log(err);
            }
      });

      // Photos in maps listener
      document.addEventListener('PLP_photos_in_maps', function (e) {
            //console.log('PLP_photos_in_maps');
            try {
                  let plp_listing_image = document.getElementsByClassName("plp_listing_image");
                  if (plp_listing_image.length) {
                        for (let i = 0; i < plp_listing_image.length + 1; i++) {
                              plp_listing_image.item(i).remove();
                        }
                  }
                  //In maps
                  if (window.location.href.indexOf('maps/place') !== -1) {
                        let userImages = window.location.href.indexOf("googleusercontent");
                        if (userImages !== -1) {
                              setTimeout(function () {
                                    var current_url = decodeURIComponent(window.location.href);
                                    //console.log('current_url ' + current_url);
                                    let imageStart = current_url.indexOf("https://l");
                                    let part = current_url.substring(imageStart);
                                    let endPart = part.indexOf("=w");
                                    var imageURL = part.substring(0, endPart) + '=w' + window.innerWidth + '-h' + window.innerHeight + '-k-no';
                                    //console.log('imageURL ' + imageURL);
                                    let imageBottomLine = document.getElementsByClassName("fineprint-copyrights");
                                    let finePrint = document.getElementsByClassName("id-fineprint");
                                    let h1Tag = document.getElementsByTagName("h1");

                                    if (typeof h1Tag !== 'undefined' && typeof h1Tag[0] !== 'undefined') {
                                          h1Tag[0].innerHTML += " <a href='" + imageURL + "' class='plp_listing_image' target='_blank'> - url</a>";
                                    } else if (typeof finePrint !== 'undefined' && typeof finePrint[0] !== 'undefined') {
                                          finePrint[0].innerHTML += " <a href='" + imageURL + "' class='plp_listing_image' target='_blank'>Image URL</a>";
                                    } else if (typeof imageBottomLine !== 'undefined' && typeof imageBottomLine[0] !== 'undefined') {
                                          imageBottomLine[0].innerHTML += "<a href='" + imageURL + "' class='plp_listing_image' target='_blank'> - URL</a>";
                                    } else {
                                          let imageBottomLine = document.getElementsByClassName("fineprint-copyrights");
                                          if (typeof imageBottomLine !== 'undefined' && typeof imageBottomLine[0] !== 'undefined') {
                                                imageBottomLine[0].innerHTML += "<a href='" + imageURL + "' class='plp_listing_image' target='_blank'> - URL</a>";
                                          }
                                    }
                              }, 999);
                        }
                  } else {
                        //Local Finder
                        var the_respones = e.detail.replace(")]}'", '');
                        var json_result = JSON.parse(the_respones);
                        if (json_result && json_result[1][0][1][1]) {
                              var imageURL = "https://lh5.googleusercontent.com/p/" + json_result[1][0][1][1] + "=w1920-h912-k-no";
                              setTimeout(function () {
                                    let imageBottomLine = document.getElementsByClassName("fineprint-copyrights");
                                    if (typeof imageBottomLine !== 'undefined' && typeof imageBottomLine[0] !== 'undefined') {
                                          imageBottomLine[0].innerHTML += "<a href='" + imageURL + "' class='plp_listing_image' target='_blank'> - URL</a>";
                                    } else {
                                          let imageBottomLine = document.getElementsByClassName("fineprint-copyrights");
                                          if (typeof imageBottomLine !== 'undefined' && typeof imageBottomLine[0] !== 'undefined') {
                                                imageBottomLine[0].innerHTML += "<a href='" + imageURL + "' class='plp_listing_image' target='_blank'> - URL</a>";
                                          }
                                    }
                              }, 999);
                        }
                  }

            } catch (err) {
                  console.log('PLP Error: PLP_photos_in_maps: ');
                  console.log(err);
            }
      });

//      // Maps Reveal ... PLP_maps_reveal
//      document.addEventListener('PLP_maps_reveal', function (e) {
//            try {
//                  var address = e.detail[1][0] + '#';
//                  setTimeout(function () {
//                        var reveal_card = document.getElementById("reveal-card");
//                        if (reveal_card) {
//                              let direction_btn = document.querySelectorAll('[class*="widget-reveal-card-directions"]');
//                              if (direction_btn && direction_btn.length == 2) {
//                                    var brightlocal_btn = '<a href="https://shareasale.com/r.cfm?b=314694&amp;u=1654343&amp;m=33269&amp;urllink=www.brightlocal.com%2Flocal-search-results-checker%2F%3Fsearch-location%3D' + encodeURIComponent(address) + '&amp;afftrack=" target="_blank" title="Check Google local search results from this location"><img width="30px" src="data:image/webp;base64,UklGRtoBAABXRUJQVlA4TM4BAAAvH8AHEFehOJKkBHf5EQ75F8nwPUHSYBtJkpPX+hEWaZB/GkSCBX+SQQCAZWZbtda/xW0oaNvI8Q3ah+qZPJ2l+Po3w3mE/l9YuL/516N7Pl+IMSWjC4sLmwMLXrMLC/oG/I94jQ4sLqwun9bzebbY7we0SV3op1e6YhJlA1Y3w2XGZ2ZcRWxSKIRNwrw7n7myKbFJbTPqpuWpwWFkW2nFxeLG++7yov13CLEOIvo/AUJoJbGxVFoIobCrEho7a7WXkiGTZKmZkZ/n6z8j4ZvCERHVGQD56JmZh2vkBeOGqjxOipoKRBPPjtGMbShFsKBq4oVjFCopA0yWGqA48OJzwLoSyB2Ri4HR62/P0Wv/XkoZEirjtGlk1DJzGwEYmZlfXk4xcrJATsmXmfkCAG/vFjLIKfXij3f2ngtSSmBcneauQqD9AWbwXp51JZDURJXB1+P2cu2YmdvIQ04pgFgC+AfmLwjK2qUIR8tGE4KtXRrCoiHCvK1dGuoW9H8stTVlgX5u+GO5qSj3hpkxwlpZUgFgDE0GG5ZUAlPgIrFpQaU8e1dsnVN1YeY7ts/oxPzEnumxfWOlXIHfByulWrNe6b20UPsoIYRWciuptBA=" style="margin-top: 10px;"></a>';
//                                    var node = document.createElement("button");
//                                    node.innerHTML = brightlocal_btn;
//                                    node.setAttribute("class", direction_btn[0].className);
//                                    Element.prototype.appendAfter = function (element) {
//                                          element.parentNode.insertBefore(this, element.nextSibling);
//                                    }, false;
//                                    node.appendAfter(direction_btn[0]);
//                              }
//
//                        }
//                  }, 300);
//            } catch (err) {
//                  console.log('PLP Error: PLP_duckduckgo_maps_results: ');
//                  console.log(err);
//            }
//      });

      // DuckDuckgo Maps Results
//      document.addEventListener('PLP_duckduckgo_maps_results', function (e) {
//            try {
//                  return;
//                  if (window.location.href.indexOf("first_search") !== -1 && typeof window.plp_duckduckgo_clicked === 'undefined') {
//                        window.plp_duckduckgo_clicked = 1;
//                        var search_results = JSON.parse(e.detail);
//                        if (!search_results.results) {
//                              let search_btn = document.querySelectorAll('[class*="js-vertical-map-search-button"]');
//                              search_btn[search_btn.length - 1].click();
//                        }
//
//                        //var newUrl = window.location.href.replace('first_search', 'clicked')
//                        //history.pushState({}, null, newUrl);
//                  } else {
//                        var search_results = JSON.parse(e.detail);
//                        if (search_results.results) {
//                              setTimeout(function () {
//                                    let results_container = document.querySelectorAll('[class="place-list-item__info"]');
//                                    if (results_container) {
//                                          for (i = 0; i < results_container.length; i++) {
//                                                if (typeof search_results.results[i] !== 'undefined') {
//                                                      if (typeof search_results.results[i].phone !== 'undefined' && search_results.results[i].phone) {
//                                                            if (window.location.href.indexOf(search_results.results[i].phone) !== -1) {
//                                                                  results_container[i].innerHTML += "<li class='place-list-item__info__item' style='color:yellow'>Phone: " + search_results.results[i].phone + "<li>";
//                                                            } else {
//                                                                  results_container[i].innerHTML += "<li class='place-list-item__info__item'>Phone: " + search_results.results[i].phone + "<li>";
//                                                            }
//
//                                                      }
//                                                      if (typeof search_results.results[i].engine !== 'undefined') {
//                                                            results_container[i].innerHTML += "<li class='place-list-item__info__item'>Engine: <a href='" + search_results.results[i].url + "' target='_blank'>" + search_results.results[i].engine + "</a><li>";
//                                                      }
//                                                }
//
//                                          }
//                                    }
//                              }, 2500);
//                        }
//                  }
//            } catch (err) {
//                  console.log('PLP Error: PLP_duckduckgo_maps_results: ');
//                  console.log(err);
//            }
//      });
}  else if (n7 || n8) {
      //Get Api Key / Sig
      if (window.location.href.indexOf("do=api_key_sig") !== -1) {
            chrome.storage.sync.get(['plpAskedForApiKey'], function (val) {
                  if (val['plpAskedForApiKey'] !== 1) {
                        if (!window.plpAskedForApiKey && window.confirm('Add API Key and Signature to the PlePer Chrome Extension?')) {
                              chrome.storage.sync.set({plpAskedForApiKey: '1'});
                              var xhr = new XMLHttpRequest();
                              xhr.open("GET", "https://pleper.com/ajax.php?do=get_api_key");
                              xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                              xhr.send();
                              xhr.onreadystatechange = function () {
                                    if (xhr.readyState === 4) {
                                          var data = JSON.parse(xhr.response);
                                          //console.log(data);
                                          if (data['api-key']) {
                                                chrome.storage.sync.set({plpToolsApiKey: data['api-key']});
                                                chrome.storage.sync.set({plpToolsApiSig: data['api-signature']});
                                          }
                                    }
                              }
                        } else {
                              chrome.storage.sync.set({plpAskedForApiKey: '1'});
                        }
                  }
            });
      }
}